/*
 * Decompiled with CFR 0.152.
 */
package com.aote.workflow.perform;

import com.aote.workflow.perform.ActivityDef;
import com.aote.workflow.perform.ActorDef;
import com.aote.workflow.perform.Diagram;
import com.aote.workflow.perform.DiversionDef;
import com.aote.workflow.perform.FlowDef;
import com.aote.workflow.perform.InvalidActivityInstanceException;
import com.aote.workflow.perform.ProcessInstance;
import com.aote.workflow.perform.VarDef;
import com.aote.workflow.perform.VarInstance;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ProcessDef
extends FlowDef {
    static Logger log = Logger.getLogger(ProcessDef.class);
    private static final long serialVersionUID = -8854627878683187720L;
    private LinkedList activities = new LinkedList();
    private LinkedList diversions = new LinkedList();
    private LinkedList actors = new LinkedList();
    private LinkedList<VarDef> vars = new LinkedList();

    public ProcessDef(Diagram diagram) throws Exception {
        this.name = diagram.getName();
        this.setDiagram(diagram);
    }

    public LinkedList<VarDef> getVars() {
        return this.vars;
    }

    public ActivityDef getActivity(String ID) {
        for (int i = 0; i < this.activities.size(); ++i) {
            ActivityDef activity = (ActivityDef)this.activities.get(i);
            if (!activity.getID().equals(ID)) continue;
            return activity;
        }
        throw new InvalidActivityInstanceException("\u6d41\u7a0b\u5b9a\u4e49\u91cc\u6ca1\u6709\u7ed9\u5b9a\u53f7\u7684\u6d3b\u52a8\u5b9a\u4e49\uff1a\u6d41\u7a0b\u5b9a\u4e49=" + this.name + "\u6d3b\u52a8\u5b9a\u4e49\u53f7=" + ID);
    }

    public ProcessInstance createInstance(Session session, String id) throws Exception {
        ProcessInstance ins = new ProcessInstance(this, id);
        ins.setState("\u5f00\u59cb");
        session.save((Object)ins);
        VarInstance vi = ins.getVars().iterator().next();
        session.save((Object)vi);
        return ins;
    }

    public ActivityDef getStartActivity() {
        return (ActivityDef)this.activities.get(0);
    }

    public LinkedList getDiversions() {
        return this.diversions;
    }

    public DiversionDef getDiverison(ActivityDef head, ActivityDef tail) {
        for (int i = 0; i < this.diversions.size(); ++i) {
            DiversionDef def = (DiversionDef)this.diversions.get(i);
            if (!def.getHead().getID().equals(head.getID()) || !def.getTail().getID().equals(tail.getID()) || def.getType().equals("\u7ed3\u675f")) continue;
            return def;
        }
        return null;
    }

    public DiversionDef getDiversionDefById(String id) {
        for (int i = 0; i < this.getDiversions().size(); ++i) {
            DiversionDef diversionDef = (DiversionDef)this.getDiversions().get(i);
            if (!diversionDef.getID().equals(id)) continue;
            return diversionDef;
        }
        return null;
    }

    public void setDiagram(Diagram diagram) {
        try {
            this.clearList();
            String context = diagram.getContext();
            StringReader reader = new StringReader(context);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new InputSource(reader));
            ((Reader)reader).close();
            NodeList wnl = document.getElementsByTagName("WorkflowDiagram");
            Element e = (Element)wnl.item(0);
            this.setElement(e);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6d41\u7a0b\u6587\u4ef6" + diagram.getName() + "\u751f\u6210Document\u65f6\u51fa\u73b0\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public void setElement(Element e) {
        LinkedList oldActors = (LinkedList)this.actors.clone();
        this.actors.clear();
        LinkedList oldActivities = (LinkedList)this.activities.clone();
        this.activities.clear();
        LinkedList oldDiversions = (LinkedList)this.diversions.clone();
        this.diversions.clear();
        this.vars.clear();
        this.loadItems(e, oldActors, oldActivities, oldDiversions);
    }

    private void loadItems(Element e, LinkedList oldActors, LinkedList oldActivities, LinkedList oldDiversions) {
        Element ee;
        int i;
        NodeList nl = e.getElementsByTagName("Actor");
        for (i = 0; i < nl.getLength(); ++i) {
            ee = (Element)nl.item(i);
            ActorDef actor = (ActorDef)this.getDefByID(oldActors.iterator(), ee.getAttribute("id"));
            if (e.getTagName().equals("invalids")) {
                log.debug((Object)("load actor:" + ee.getAttribute("id")));
            }
            if (actor == null) {
                actor = new ActorDef(ee);
            } else {
                actor.setElement(ee);
            }
            this.actors.add(actor);
            NodeList children = ee.getElementsByTagName("Activity");
            for (int j = 0; j < children.getLength(); ++j) {
                Element child = (Element)children.item(j);
                ActivityDef activity = (ActivityDef)this.getDefByID(oldActivities.iterator(), child.getAttribute("id"));
                if (e.getTagName().equals("invalids")) {
                    log.debug((Object)("load activity:" + child.getAttribute("id")));
                }
                if (activity == null) {
                    activity = new ActivityDef(actor, this, child);
                } else {
                    activity.setElement(child);
                }
                if (child.hasAttribute("personexpression")) {
                    String personExpression = child.getAttribute("personexpression");
                    activity.setPersonExpression(personExpression);
                }
                if (child.hasAttribute("timeout")) {
                    String timeout = child.getAttribute("timeout");
                    activity.setTimeout(timeout);
                }
                if (child.hasAttribute("nodetype")) {
                    String nodetype = child.getAttribute("nodetype");
                    activity.setNodetype(nodetype);
                }
                actor.setActivities(activity);
                this.activities.add(activity);
            }
        }
        log.debug((Object)"actors end.");
        nl = e.getChildNodes();
        for (i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals("Diversion")) continue;
            ee = (Element)nl.item(i);
            try {
                ActivityDef headDef = this.getActivity(ee.getAttribute("head"));
                ActivityDef tailDef = this.getActivity(ee.getAttribute("tail"));
                DiversionDef def = (DiversionDef)this.getDefByID(oldDiversions.iterator(), ee.getAttribute("id"));
                if (def == null) {
                    def = new DiversionDef(headDef, tailDef, ee);
                } else {
                    def.setElement(ee);
                }
                this.diversions.add(def);
                continue;
            }
            catch (InvalidActivityInstanceException ex) {
                System.out.println("error diversion is: " + ee.getAttribute("id"));
                throw ex;
            }
        }
        log.debug((Object)"diversions end.");
        nl = e.getChildNodes();
        for (i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals("Var")) continue;
            ee = (Element)nl.item(i);
            VarDef varDef = new VarDef(ee);
            this.vars.add(varDef);
        }
        log.debug((Object)"diversions end.");
    }

    private FlowDef getDefByID(Iterator v, String ID) {
        while (v.hasNext()) {
            FlowDef def = (FlowDef)v.next();
            if (!def.getID().equals(ID)) continue;
            return def;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public void clearList() {
        this.activities.clear();
        this.actors.clear();
        this.diversions.clear();
    }

    public ActivityDef getActivityByName(String name) {
        for (ActivityDef activity : this.activities) {
            if (!activity.name.equals(name)) continue;
            return activity;
        }
        return null;
    }

    public List getActivities() {
        return this.activities;
    }

    public List getActors() {
        return this.actors;
    }

    public ActorDef getActorByActivityId(String id) {
        for (ActorDef actor : this.actors) {
            for (ActivityDef act : actor.getActivities()) {
                if (!act.ID.equals(id)) continue;
                return actor;
            }
        }
        return null;
    }
}

