package com.aote.workflow.plugin;

import com.aote.transaction.SessionPool;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;

import com.aote.rs.Server;
import com.aote.sql.SqlServer;
public class WorkFlowLogicServer {

	//private Server server;

	public void setService (Session session) {
		Server server = new Server();
		server.setAssignedSession(session);
	}

	/**
	 * 通过外面的SqlServer设置session
	 * @param sql 可以不用
	 */
	public void setServiceBySqlServer(SqlServer sql) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
	}

	/**
	 * 
	 * @param name
	 * @param username
	 * @param userid
	 * @param personExpression
	 * @return
	 */
	public String startWorkFlow (String name,String username,
								 String userid,
								 JSONObject personExpression) {
		JSONArray arr = new JSONArray();
		String personExpressionArr = arr.put(personExpression).toString();
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		String process = server.txstartProcess(name, username, userid, personExpressionArr);
		return process;
	}

	/**
	 * 开启一个流程
	 * @param name 流程名
	 * @return 流程实例编号
	 */
	public String startWorkflow(String name) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		String result = server.txstartProcess(name);
		return result;
	}

	/**
	 * 开始一个活动
	 * @param processid 流程实例id
	 * @param name 活动名称
	 * @return
	 */
	public String startActivity(String processid, String name) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		String result = server.txstartActivity(processid, name);
		return result;
	}

	/**
	 * 流程中变量变化
	 * @param processid 流程id
	 * @param vars: JSON串 形式的变量值，形式：{varname: value}
	 */
	public void setVars(String processid, String vars) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		server.txsetVars(processid, vars, "", "");
	}

	/**
	 * 流程中变量变化
	 * @param processid 流程id
	 * @param vars: JSON串 形式的变量值，形式：{varname: value}
	 */
	public void setVars(String processid, String vars, String username, String userid) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		server.txsetVars(processid, vars, username, userid);
	}

	/**
	 * 以json串方式给流程变量赋值
	 * @param processid 流程id
	 * @param json json对象
	 */
	public void setVars(String processid, JSONObject json) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		server.txsetVars(processid, json.toString(), "", "");
	}

	/**
	 * 以json串方式给流程变量赋值
	 * @param processid 流程id
	 * @param json json对象
	 */
	public JSONObject setVars(String processid, JSONObject json, String username, String userid) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		return server.ttxsetVars(processid, json.toString(), username, userid);
	}

	/**
	 * 取得活动定义中action属性内容
	 * @param activityId: 活动实例ID
	 * @return
	 */
	public String getAction(String activityId) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		return server.txgetAction(activityId);
	}


	/**
	 * 获取当前待办
	 * @param processid
	 * @return
	 */
	public String getWait(String processid) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		return server.txgetWait(processid);
	}

	/**
	 * 获取工作流程图
	 * 得到一批点和一批有方向线
	 * @param processid
	 * @return
	 */
	public String getWFGraph(String processid) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		return server.txgetWFGraph(processid);
	}

	/**
	 *
	 * @param acitityid
	 * @param username
	 * @param userid
	 * @param personExpression
	 * @return
	 */
	public String excuteWorkFlow(String acitityid,
								 String username,
								 String userid,
								 JSONObject personExpression) {
		JSONArray arr = new JSONArray();
		String personExpressionArr = arr.put(personExpression).toString();
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		String process = server.txperformActivity(acitityid.toString(), username, userid, personExpressionArr);
		return process;
	}

	/**
	 * ֹͣ
	 * @param acitityid
	 * @return
	 */
	public String stopWorkFlow(String acitityid) {
		Server server = new Server();
		Session session = SessionPool.getInstance().getSession();
		server.setAssignedSession(session);
		String process = server.txStopProcess(acitityid);
		return process;
	}

	/*
	 * 从执行者表达式R/P(执行者) 获取 执行者
	 * 参数：执行者表达式 actorexpression
	 * @return:执行者
	 */
	public String getOperator(String actorexpression ){
		if(actorexpression.indexOf("(") != -1 && actorexpression.length()>3){
			return actorexpression.substring(actorexpression.indexOf("(") + 1, actorexpression.indexOf(")"));
		}else{
			return "";
		}
	}
}