/*
 * Decompiled with CFR 0.152.
 */
package com.aote.workflow.perform;

import com.aote.workflow.perform.Diagram;
import com.aote.workflow.perform.DiagramManager;
import com.aote.workflow.perform.ProcessDef;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class ProcessDefManager {
    private static final long serialVersionUID = 7046680794343910842L;
    private static ProcessDefManager instance;
    private Hashtable nameAndProcesses = new Hashtable();

    public static ProcessDefManager getInstance() {
        return instance;
    }

    public ProcessDefManager() {
        instance = this;
    }

    public void load() throws Exception {
        DiagramManager manager = DiagramManager.getInstance();
        Enumeration v = manager.getDiagrams();
        while (v.hasMoreElements()) {
            Diagram diagram = (Diagram)v.nextElement();
            this.nameAndProcesses.put(diagram.getName(), new ProcessDef(diagram));
        }
    }

    public void reLoadProcessDefByName(Diagram d) throws Exception {
        ProcessDef def = this.getProcessDef(d.getName());
        if (def != null) {
            def.setDiagram(d);
        } else {
            def = new ProcessDef(d);
        }
        this.nameAndProcesses.put(d.getName(), def);
    }

    public ProcessDef getProcessDef(String name) {
        return (ProcessDef)this.nameAndProcesses.get(name);
    }

    public Enumeration getProcesses() {
        return this.nameAndProcesses.elements();
    }

    public Iterator getProcessesIterator() {
        return this.nameAndProcesses.values().iterator();
    }
}

