/*
 * Decompiled with CFR 0.152.
 */
package com.aote.workflow.perform;

import com.aote.workflow.perform.Diagram;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class DiagramManager {
    static Logger log = Logger.getLogger(DiagramManager.class);
    private static final long serialVersionUID = 373843474314241569L;
    private static DiagramManager instance = new DiagramManager();
    private Hashtable nameAndDiagrams = new Hashtable();

    public static DiagramManager getInstance() {
        return instance;
    }

    public DiagramManager() {
        this.load();
    }

    public void load() {
        File[] files;
        String path = this.getClass().getClassLoader().getResource("/processes/").getPath();
        for (File f : files = new File(path).listFiles()) {
            String fileName = f.getName();
            if (fileName == null) continue;
            try {
                String digName = fileName.substring(0, fileName.indexOf("."));
                Diagram diagram = new Diagram();
                diagram.setName(digName);
                this.nameAndDiagrams.put(digName, diagram);
                String result = "";
                String encoding = "GBK";
                InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(f), encoding);
                BufferedReader bufferedReader = new BufferedReader(read);
                String lineTxt = null;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    result = result + lineTxt;
                }
                bufferedReader.close();
                diagram.setContext(result);
            }
            catch (Exception e) {
                log.error((Object)("\u6d41\u7a0b" + fileName + ": " + e.getMessage()));
            }
        }
    }

    public Enumeration getDiagrams() throws RemoteException {
        return this.nameAndDiagrams.elements();
    }

    public LinkedList getDiagramNames() throws RemoteException {
        return new LinkedList(this.nameAndDiagrams.keySet());
    }

    public Diagram getDiagramByName(String name) throws RemoteException {
        return (Diagram)this.nameAndDiagrams.get(name);
    }
}

