SELECT
    f_open_id,
    convert(varchar,f_balance) f_balance,
    f_userinfo_id,
    f_userfiles_id,
    f_user_name,
    f_meternumber,
    f_time,
    f_filialeids,
    f_userinfo_code,
    f_orgid,
    f_orgname
FROM (
         SELECT
             b.f_open_id,
             b.f_band_state,
             f_user_state,
             f_table_state,
             -- 物联网取f_balance_amount,机表取f_balance,保留两位然后转字符串
             convert(decimal(18,2), CASE WHEN uf.f_meter_classify = '物联网表' THEN uf.f_balance_amount ELSE ui.f_balance END) f_balance,
             ui.f_userinfo_id,
             uf.f_userfiles_id,
             ui.f_user_name,
             uf.f_meternumber,
             CONVERT(varchar,GETDATE(),120) f_time,
             ui.f_filialeids,
             ui.f_userinfo_code,
             ui.f_orgid,
             'fugu' f_orgname
         FROM
             t_banduser b
                 LEFT JOIN t_userinfo ui on ui.f_userinfo_id = b.f_userinfo_id
                 LEFT JOIN t_userfiles uf ON ui.f_userinfo_id = uf.f_userinfo_id
         where uf.f_meter_classify IN ('机表', '物联网表')
     ) c where f_band_state = '有效' and f_user_state = '正常' and f_balance < 30  and f_table_state = '正常'
