select
    f_userinfo_id,   --用户编号
    f_user_id f_userfiles_id,
    f_userinfo_code,
    f_open_id,
    f_user_name,		--用户姓名
    f_address,		--地址
    '机表欠费' f_owe_type,
    f_filiale f_orgname,
    f_filiale f_orgid,
    sum(f_balance) f_balance,		--账户余额
    min(f_last_tablebase) f_last_tablebase,
    max(f_tablebase) f_tablebase,
    case when MIN(f_hand_date)=MAX(f_hand_date) then MAX(f_hand_date)
         else MIN(f_hand_date)+'至'+MAX(f_hand_date) end f_hand_date,		--欠费月份
    isnull(sum(f_oughtamount), 0) f_oughtamount,--欠费气量
    isnull(SUM(f_oughtfee), 0) f_oughtfee,		--欠费金额
    isnull(SUM(f_deplay), 0) f_deplay,			--滞纳金
    cast(isnull(SUM(f_oughtfee), 0)+isnull(SUM(f_deplay), 0)-sum(f_balance) as varchar)  f_oughtfee_all  --实际欠费金额
from(
        SELECT
            *
        FROM
            (
                SELECT
                    u2.id,				--抄表id
                    u1.f_userinfo_id,   --用户编号
                    u1.f_userinfo_code,
                    u1.f_user_name,		--用户姓名
                    u1.f_user_phone,	--用户电话
                    u1.f_address,		--地址
                    u1.f_residential_area,			--小区
                    u1.f_building,
                    u1.f_unit,
                    u1.f_room,
                    u1.f_slice_area,	--
                    u1.f_user_type,		--用户类型
                    u1.f_user_state,
                    u1.f_gasproperties,	--用气方式
                    u2.f_balance,		--账户余额
                    u2.f_tablebase,
                    u2.f_last_tablebase,
                    u2.f_filiale,
                    u2.f_filiale f_orgname,
                    u2.f_filiale f_orgid,
                    u2.f_outlets,
                    isnull(CONVERT(varchar(100), u2.f_hand_date, 23),'') f_hand_date,		--欠费月份
                    isnull(u2.sumoughtamount, 0) f_oughtamount,--欠费气量
                    isnull(u2.sumoughtfee, 0) f_oughtfee,		--欠费金额
                    zhinaday,
                    b.f_open_id,
                    value,
                    f_user_id,
                    isnull(sumzhinajin, 0) f_deplay,			--滞纳金
                    isnull(u2.sumoughtfee, 0)+isnull(sumzhinajin, 0)-u2.f_balance qianfei  --实际欠费金额
                FROM
                    t_userinfo u1
                    left join t_banduser b on u1.f_userinfo_id=b.f_userinfo_id
                    LEFT JOIN (
                    SELECT
                        id,
                        f_userinfo_id,						--用户编号
                        f_user_id,
                        f_hand_date,
                        f_balance,
                        f_tablebase,
                        f_last_tablebase,
                        f_filiale,
                        f_outlets,
                        zhinaday,
                        value,
                        f_oughtamount sumoughtamount,	--欠费总气量
                        f_oughtfee sumoughtfee,			--欠费总金额
                        case when isnull(zhinajin,0)>=f_oughtfee then f_oughtfee else isnull(zhinajin,0) end  sumzhinajin	--欠费滞纳金合计
                    FROM
                        (
                            SELECT
                                h1.id,
                                h1.f_userinfo_id,
                                h1.f_user_id,
                                h1.f_user_type,
                                h1.f_oughtamount,
                                h1.f_oughtfee,
                                h1.f_tablebase,
                                h1.f_last_tablebase,
                                h1.f_filiale,
                                h1.f_outlets,
                                h1.f_hand_date,
                                isnull(h2.f_balance,0) f_balance,
                                CASE WHEN DATEDIFF(dd,isnull(h1.f_end_date, getdate()),getdate()) < 0
                                         THEN 0 ELSE DATEDIFF(dd,isnull(h1.f_end_date, getdate()),getdate()) END zhinaday,--滞纳天数
                                cast(h3.VALUE as NUMERIC (20, 4)) value,--滞纳金比率
                        --直接计算滞纳金
                        --欠费金额*滞纳天数*滞纳金比例=滞纳金,
                        CAST (
                             ROUND(isnull(h2.oughtfee, h1.f_oughtfee) * (
                                CASE WHEN DATEDIFF(dd,isnull(h1.f_end_date, getdate()),getdate()) < 0
                                    THEN 0 ELSE DATEDIFF(dd,isnull(h1.f_end_date, getdate()),getdate()) END
                                ) * cast(h3.VALUE as NUMERIC (20, 4)),2)
                             AS NUMERIC (20, 3))  zhinajin
                            FROM
                                V_handplan h1
                                LEFT JOIN (
                                --每一用户最早一条欠费记录减去账户余额
                                SELECT
                                n1.id,
                                n2.f_balance,
                                (n1.f_oughtfee) oughtfee
                                FROM
                                (
                                SELECT * FROM
                                V_handplan m1
                                WHERE
                                EXISTS (
                                SELECT *
                                FROM
                                (
                                SELECT MIN (id) id FROM V_handplan
                                WHERE f_whether_pay = '否' AND f_meter_states = '已抄表'
                                GROUP BY f_userinfo_id
                                ) m2
                                WHERE
                                m1.id = m2.id
                                )
                                ) n1
                                LEFT JOIN t_userinfo n2 ON n1.f_userinfo_id = n2.f_userinfo_id
                                ) h2 ON h1.id = h2.id
                                LEFT JOIN t_singlevalue h3 ON (
                                CASE h1.f_user_type
                                WHEN '民用' THEN
                                '民用违约金'
                                ELSE
                                '非民用违约金'
                                END
                                ) = h3.name
                            WHERE
                                h1.f_whether_pay = '否'
                              AND h1.f_meter_states = '已抄表'
                        ) hand
                    ) u2 ON u1.f_userinfo_id = u2.f_userinfo_id
                where u1.f_user_state = '正常'
            ) ss
        WHERE  f_open_id is not null and qianfei > 0 and  {condition}
    ) s group by f_userinfo_id,f_user_name,f_address,f_open_id,f_filiale,f_user_id,f_userinfo_code

