package com.aote.weixin.timer;

import cn.hutool.http.HttpUtil;
import com.aote.entity.WxBillRecord;
import com.aote.entity.WxPaySendData;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.util.WechatUrl;
import com.aote.util.WxSign;
import com.aote.weixin.Config;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ContextLoader;


import java.text.SimpleDateFormat;
import java.util.*;

@Component
public class recordFile {
	static org.slf4j.Logger log = LoggerFactory.getLogger(recordFile.class);
	

	@Autowired
	private LogicServer logicServer;
	public void getwxRecordFile() {
		log.debug("获取微信对账文件");
		System.out.println("获取微信对账文件");
		try {
			String recordBillFiliale = Config.wechatConfig.getString("recordBillFiliale");
			String[] filialeArrray = recordBillFiliale.split("-");
			for (int i = 0; i < filialeArrray.length; i++) {
				log.debug(filialeArrray[i]);
				org.json.JSONObject wxConfig = Config.getConfig(filialeArrray[i]);
				// 公众账号ID
				String appId = wxConfig.getString("appId");
				// 商户号
				String mchId = wxConfig.getString("mchId");
				String key = wxConfig.getString("key");
				// 随机字符串
				String nonceStr = WxSign.getNonceStr();
				// 对账单日期
				Calendar cal = Calendar.getInstance();
				cal.add(Calendar.DATE,-1);

				String billDate = new SimpleDateFormat("yyyyMMdd").format(cal.getTime());
				String time = new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
				/**
				 * 账单类型
				 * ALL（默认值），返回当日所有订单信息（不含充值退款订单）
				 * SUCCESS，返回当日成功支付的订单（不含充值退款订单）
				 * REFUND，返回当日退款订单（不含充值退款订单）
				 * RECHARGE_REFUND，返回当日充值退款订单
				 */
				String billType = "SUCCESS";
				// 生成sign签名
				SortedMap<Object, Object> parameters = new TreeMap<Object, Object>();
				parameters.put("appid", appId);
				parameters.put("mch_id", mchId);
				parameters.put("nonce_str", nonceStr);
				parameters.put("bill_date", billDate);
				parameters.put("bill_type", billType);
				// 签名
				String sign = WxSign.createSign(parameters, key);
				WxBillRecord data = new WxBillRecord();
				data.setAppid(appId);
				data.setBill_date(billDate);
				data.setBill_type(billType);
				data.setMch_id(mchId);
				data.setNonce_str(nonceStr);
				data.setSign(sign);
				XStream xs = new XStream(new DomDriver("UTF-8", new XmlFriendlyNameCoder("-_", "_")));
				xs.alias("xml", WxPaySendData.class);
				String xml = xs.toXML(data);
				log.debug("微信支付下单数据:" + xml);
				String url = WechatUrl.DOWNLOAD_BILL_API;
				String bill = HttpUtil.post(url, xml, 10000);
				String[] values = bill.split("`" + time);
				log.debug("values:" + values.length);
				for (int j = 1; j < values.length; j++ ) {
					String [] line = values[j].split(",`");
					org.json.JSONObject json = new org.json.JSONObject();
					json.put("f_trade_time", time + line[0]);
					json.put("f_appid", line[1]);
					json.put("f_mch_id", line[2]);
					json.put("f_device_info", line[3]);
					json.put("f_transaction_id", line[5]);
					json.put("f_out_trade_no", line[6]);
					json.put("f_openid", line[7]);
					json.put("f_trade_type", line[8]);
					json.put("f_return_code", line[9]);
					json.put("f_bank_type", line[10]);
					json.put("f_fee_type", line[11]);
					json.put("f_cash_fee", line[12]);
					json.put("f_coupon_fee", line[13]);
					json.put("f_body", line[14]);
					json.put("f_attach", line[15]);
					json.put("f_service_charge", line[16]);
					json.put("f_rate", line[17]);
					json.put("f_total_fee", line[18]);
					json.put("f_filiale", filialeArrray[i]);
					log.info("每一行的数据转换位json后为：" + json);
					logicServer.run("savewxrecordbill", json);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void getBankRecordFile() {
		log.debug("获取银行对账文件");
		System.out.println("获取微信对账文件");
		try {
			JSONObject json = new JSONObject();
			String recordBillFiliale = Config.wechatConfig.getString("recordBillFiliale");
			String flag = Config.wechatConfig.getString("flag");
			Calendar cal = Calendar.getInstance();
			cal.add(Calendar.DATE,-1);
			String txnDate = new SimpleDateFormat( "yyyyMMdd").format(cal.getTime());
			// 获取到相应的银行处理实现类

			json.put("flag",flag);
			json.put("f_filiale",recordBillFiliale);
			json.put("txnDate",txnDate);
			log.debug("json"+ json);
			flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
			RefundSuper refundSuper = (RefundSuper) ContextLoader.getCurrentWebApplicationContext().getBean(flag);

			// 调起下单程序
			JSONObject  result = refundSuper.getRecordFile(json);
			log.debug(result.toString());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
