package com.aote.weixin.timer;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.rs.wechatpay.WxAdjustPayment;
import com.aote.rs.wechatpay.WxConstructionPayment;
import com.aote.rs.wechatpay.WxOtherPayment;
import com.aote.rs.wechatpay.WxPayment;
import com.aote.sql.SqlServer;
import com.aote.util.PayUtil;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.ContextLoader;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;


/**
 * @author JoeCdy
 * @Description 微信公众号订单处理
 * @createTime 2020年04月08日 18:45:00
 */
@Component
public class OrderProcess {

    static Logger log = Logger.getLogger(OrderProcess.class);

    @Autowired
    private SqlServer sqlServer;

    @Autowired
    public SessionFactory sessionFactory;

    /**
     * 燃气收费回调
     */
    @Autowired
    private WxPayment wxPayment;

    /**
     * 其他收费回调
     */
    @Autowired
    private WxOtherPayment wxOtherPayment;

    /**
     * 调价补差回调
     */
    @Autowired
    private WxAdjustPayment wxAdjustPayment;

    /**
     * 报装回调
     */
    @Autowired
    private WxConstructionPayment wxConstructionPayment;

    // 查询订单时间的规定
    private static Map<Integer, Integer> delayRules;

    /**
     * 根据下单的类型使用不同对象
     */
    private Map<String, PaySuper> paySuper = new HashMap<>();

    static {
        delayRules = new HashMap<>();
        // 前三次是秒
        delayRules.put(1, 20);
        delayRules.put(2, 20);
        delayRules.put(3, 30);
        // 下面是分钟
        delayRules.put(4, 10);
        delayRules.put(5, 30);
        delayRules.put(6, 60);
        delayRules.put(7, 60 * 3);
        delayRules.put(8, 60 * 6);
        delayRules.put(9, 60 * 12);
    }

    @PostConstruct
    public void init() {
    }

    /**
     * 线程不安全,新任务需要等上次任务执行完毕后在执行,即concurrent设置为false
     */
    @Transactional(propagation = Propagation.NEVER)
    public void run() throws Exception {
        JSONObject sqlParam = new JSONObject();
        sqlParam.put("dateNow", DateUtil.now());
        // 这种查询方法最大查询1000条数据,不过够用了
        JSONArray query = sqlServer.query("orderQuery", sqlParam);
        if (query.length() > 0) {
            log.debug("本次处理订单数量:" + query.length());
        }
        for (Object o : query) {
            try {
                this.process((JSONObject) o);
            } catch (Exception e) {
                log.debug("处理订单系统错误:", e);
            }
        }
    }

    /**
     * 订单处理
     *
     * @param row
     */
    public void process(JSONObject row) {
        String orderType = row.getString("f_order_type");
        String mendRecord = String.valueOf(row.get("f_mend_record"));
        // 查询订单状态
        log.debug("mendRecord：" + mendRecord);
        JSONObject jsonObject = new JSONObject();
        if (!"null".equals(mendRecord)) {
            JSONObject json = new JSONObject(mendRecord);
            jsonObject.put("result_code", "SUCCESS");
            jsonObject.put("trade_state", "SUCCESS");
            jsonObject.put("transaction_id", String.valueOf(json.get("transaction_id")));
            jsonObject.put("total_fee", String.valueOf(PayUtil.yuan2FenInt(json.get("tAmt"))));
            String timeEnd = String.valueOf(json.get("trdate")) + json.get("trtime");
            jsonObject.put("time_end", timeEnd);
        } else {
            // 根据下单类型获取相应的对象
            String flag = row.getString("flag");
            // 首字母转小写
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
//        log.debug("处理订单实现类: " + flag);
            if ("退款中".equals(row.getString("f_order_state"))) {
                RefundSuper refundSuper = (RefundSuper) ContextLoader.getCurrentWebApplicationContext().getBean(flag);
                jsonObject = new JSONObject(refundSuper.refundOrderStatus(row.toString()));
            } else {
                PaySuper paySuper = (PaySuper) ContextLoader.getCurrentWebApplicationContext().getBean(flag);
                jsonObject = new JSONObject(paySuper.orderStatus(row.toString()));
            }

        }
        Object id = row.get("id");
        // 支付成功
        if ("SUCCESS".equals(jsonObject.optString("trade_state"))) {
            String transaction_id = String.valueOf(jsonObject.opt("transaction_id"));
            // 更新中间表状态
            this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state = '已支付',f_transaction_id = '" + transaction_id + "' where id = '" + id + "'");
            // 订单支付成功,调用成功回调
            jsonObject.put("id", id);
            jsonObject.put("attach", row.get("f_attach"));
            // 添加订单分公司目录名
            jsonObject.put("f_filiale", row.get("f_filiale"));
            // 根据下单类型执行对应缴费逻辑
            log.debug("start-" + orderType);
            switch (orderType) {
                case "燃气收费":
                    wxPayment.pay(jsonObject.toString());
                    break;
                case "水费":
                    wxPayment.pay(jsonObject.toString());
                    break;
                case "其他收费":
                    wxOtherPayment.pay(jsonObject.toString());
                    break;
                case "调价补差":
                    wxAdjustPayment.pay(jsonObject.toString());
                    break;
                case "报装收费":
                    wxConstructionPayment.pay(jsonObject.toString());
                    break;
                default:
                    this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state = '无处理逻辑' where id = '" + id + "'");
            }
            log.debug("end-" + orderType);
        } else {
            // 不是支付成功的订单, 进行延时查询
            int judge_count = row.optInt("f_judge_count", 0) + 1;
            // 此笔订单查询已经超过了定义的最长时间,改为无效
            if (judge_count > delayRules.size() && "已下单".equals(row.getString("f_order_state"))) {
                this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state = '已无效' where id = '" + id + "'");
                return;
            } else if (judge_count > delayRules.size() && "退款中".equals(row.getString("f_order_state"))){
                this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state = '已支付' where id = '" + id + "'");
                return;
            } else if (judge_count > delayRules.size() && "待查询".equals(row.getString("f_order_state"))) {
                this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state = '已无效' where id = '" + id + "'");
                return;
            }
            DateTime dateTime;
            if (judge_count <= 3) {
                // 当前时间偏移对应秒数
                dateTime = DateUtil.offsetSecond(DateUtil.date(), delayRules.get(judge_count));
            } else {
                // 当前时间偏移对应分钟数
                dateTime = DateUtil.offsetMinute(DateUtil.date(), delayRules.get(judge_count));
            }
            String offDate = DateUtil.formatDateTime(dateTime);
            // 持久化
            SessionFactoryImplementor sf = (SessionFactoryImplementor) sessionFactory;
            String dialect = sf.getDialect().toString().toLowerCase();
            if (dialect.contains("sqlserver")) {
                this.sqlServer.runSQL("update t_weixinreturnxml set f_judge_count = " + judge_count + ",f_next_inquiry_time = '" + offDate + "' where id = '" + id + "'");
            } else if (dialect.contains("oracle")) {
                this.sqlServer.runSQL("update t_weixinreturnxml set f_judge_count = " + judge_count + ",f_next_inquiry_time = to_date('" + offDate + "','yyyy-mm-dd hh24:mi:ss') where id = '" + id + "'");
            } else {
                log.debug("数据库方言匹配异常,请注意!!!");
                this.sqlServer.runSQL("update t_weixinreturnxml set f_judge_count = " + judge_count + ",f_next_inquiry_time = '" + offDate + "' where id = '" + id + "'");
            }
        }
    }
}
