package com.aote.weixin.timer;

import cn.hutool.json.JSONObject;
import com.aote.sql.SqlServer;
import com.aote.weixin.Config;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@Component
public class MendRecord {
	static org.slf4j.Logger log = LoggerFactory.getLogger(MendRecord.class);

	@Autowired
	private SqlServer sql;

	public void getSource() {
		log.debug("扫描对账文件");
		String path = Config.wechatConfig.getString("mendRecordPath");
		File createFile = new File(path);
		// 获取当前文件夹下的一级子目录或是子文件夹,如果当前目录中没有任何内容，返回值为null
		File[] files = createFile.listFiles();
		if(files==null||files.length==0) {
			log.debug("该文件没有任何东西");
		}else {
			for(File file : files) {
				// 判断是否是文件,true:是文件,false:不是文件
				if (file.isFile()) {
					try {
						List<String> lines = FileUtils.readLines(file, "GBK");
						Iterator temp = lines.iterator();
						while(temp.hasNext()) {
							String line = String.valueOf(temp.next());
							log.info("line的值是===>" + line);
							String[] lineValues = line.split("\\|\\+\\|");
							log.info("每行数据的参数:" + Arrays.toString(lineValues));
							log.info("每行数据的参数长度:" + lineValues.length);
							if (lineValues.length > 2) {
								JSONObject json = new JSONObject();
								json.put("trdate", lineValues[1]);
								json.put("trtime", lineValues[2]);
								json.put("transaction_id", lineValues[3]);
								json.put("canal", lineValues[4]);
								json.put("userinfo_id", lineValues[5]);
								json.put("tAmt", lineValues[6]);
								log.info("每一行的数据转换位json后为：" + json);
								// 更新中间表状态
								this.sql.runSQL("update t_weixinreturnxml set f_order_state = '已支付',f_mend_record = '" + json.toString() + "',f_transaction_id = '" + lineValues[3] + "' where f_out_trade_no = '" + lineValues[3] + "' and f_transaction_id is null");
							}
						}
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			}
		}
	}
}
