package com.aote.pay.icbc.meitan;

import com.alibaba.fastjson.annotation.JSONField;

import java.math.BigDecimal;

/**
 * 税务缴费要素信息循环域
 * @Author hanls
 * @Date: 2020/9/3 12:31
 */
public class TaxGrpVo {

    /**
     * 费项的顺序号，从1开始顺序增加
     */
    @JSONField(name = "SN")
    private String sn;

    /**
     * 费项代码     缴费费项的编码
     */
    @JSONField(name = "Fee_Itm_Cd")
    private String feeItmCd;

    /**
     * 收款单位代码
     */
    @JSONField(name = "RvPyUnt_Cd")
    private String rvPyUntCd;

    /**
     * 商品子订单号  客户方系统的子订单号
     */
    @JSONField(name = "Cmdty_Sub_Ordr_No")
    private String cmdtySubOrdrNo;

    /**
     * 征收机关代码
     */
    @JSONField(name = "ClAhr_Cd")
    private String clAhrCd;

    /**
     * 费项项目用户号  纳税人编号
     */
    @JSONField(name = "Fee_Itm_Prj_Usr_No")
    private String feeItmPrjUsrNo;

    /**
     * 申报电子流水号
     */
    @JSONField(name = "Dcl_Elc_TrcNo")
    private String dclElcTrcNo;

    /**
     * 业务类型代码  01-财关类业务     02-财税类业务
     */
    @JSONField(name = "Bsn_TpCd")
    private String bsnTpCd;

    /**
     * 申报查询交易流水号  已查询过金额的交易进行上送
     */
    @JSONField(name = "Dcl_Enqr_TxnSrlNo")
    private String dclEnqrTxnSrlNo;

    /**
     * 费项项目金额  缴费金额
     */
    @JSONField(name = "Fee_Itm_Prj_Amt")
    private BigDecimal feeItmPrjAmt;

    /**
     * 备注一
     */
    @JSONField(name = "Rmrk1")
    private String rmrk1;

    /**
     * 备注二
     */
    @JSONField(name = "Rmrk2")
    private String rmrk2;

    public String getSn() {
        return sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public String getFeeItmCd() {
        return feeItmCd;
    }

    public void setFeeItmCd(String feeItmCd) {
        this.feeItmCd = feeItmCd;
    }

    public String getRvPyUntCd() {
        return rvPyUntCd;
    }

    public void setRvPyUntCd(String rvPyUntCd) {
        this.rvPyUntCd = rvPyUntCd;
    }

    public String getCmdtySubOrdrNo() {
        return cmdtySubOrdrNo;
    }

    public void setCmdtySubOrdrNo(String cmdtySubOrdrNo) {
        this.cmdtySubOrdrNo = cmdtySubOrdrNo;
    }

    public String getClAhrCd() {
        return clAhrCd;
    }

    public void setClAhrCd(String clAhrCd) {
        this.clAhrCd = clAhrCd;
    }

    public String getFeeItmPrjUsrNo() {
        return feeItmPrjUsrNo;
    }

    public void setFeeItmPrjUsrNo(String feeItmPrjUsrNo) {
        this.feeItmPrjUsrNo = feeItmPrjUsrNo;
    }

    public String getDclElcTrcNo() {
        return dclElcTrcNo;
    }

    public void setDclElcTrcNo(String dclElcTrcNo) {
        this.dclElcTrcNo = dclElcTrcNo;
    }

    public String getBsnTpCd() {
        return bsnTpCd;
    }

    public void setBsnTpCd(String bsnTpCd) {
        this.bsnTpCd = bsnTpCd;
    }

    public String getDclEnqrTxnSrlNo() {
        return dclEnqrTxnSrlNo;
    }

    public void setDclEnqrTxnSrlNo(String dclEnqrTxnSrlNo) {
        this.dclEnqrTxnSrlNo = dclEnqrTxnSrlNo;
    }

    public BigDecimal getFeeItmPrjAmt() {
        return feeItmPrjAmt;
    }

    public void setFeeItmPrjAmt(BigDecimal feeItmPrjAmt) {
        this.feeItmPrjAmt = feeItmPrjAmt;
    }

    public String getRmrk1() {
        return rmrk1;
    }

    public void setRmrk1(String rmrk1) {
        this.rmrk1 = rmrk1;
    }

    public String getRmrk2() {
        return rmrk2;
    }

    public void setRmrk2(String rmrk2) {
        this.rmrk2 = rmrk2;
    }

    @Override
    public String toString() {
        return "model.TaxGrpVo{" +
                "sn='" + sn + '\'' +
                ", feeItmCd='" + feeItmCd + '\'' +
                ", rvPyUntCd='" + rvPyUntCd + '\'' +
                ", cmdtySubOrdrNo='" + cmdtySubOrdrNo + '\'' +
                ", clAhrCd='" + clAhrCd + '\'' +
                ", feeItmPrjUsrNo='" + feeItmPrjUsrNo + '\'' +
                ", dclElcTrcNo='" + dclElcTrcNo + '\'' +
                ", bsnTpCd='" + bsnTpCd + '\'' +
                ", dclEnqrTxnSrlNo='" + dclEnqrTxnSrlNo + '\'' +
                ", feeItmPrjAmt=" + feeItmPrjAmt +
                ", rmrk1='" + rmrk1 + '\'' +
                ", rmrk2='" + rmrk2 + '\'' +
                '}';
    }
}
