package com.aote.pay.icbc.chengran;


import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcApiException;
import com.icbc.api.IcbcConstants;
import com.icbc.api.request.CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1;
import com.icbc.api.request.CardbusinessAggregatepayB2cOnlineOrderqryRequestV1;
import com.icbc.api.response.CardbusinessAggregatepayB2cOnlineConsumepurchaseResponseV1;
import com.icbc.api.response.CardbusinessAggregatepayB2cOnlineOrderqryResponseV1;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Date;


@Slf4j
@Component
public class JsApiChengRan implements PaySuper {

    @Autowired
    private LogicServer logicServer;
    

    /**
     * 聚合支付B2C线上消费下单
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        String userfilesid = json.getString("userfilesid");
        String otherType = json.getString("othertype");
        HttpServletRequest request1 = (HttpServletRequest) json.get("request");

        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        String result = "";
        try {
            if (otherType == null || otherType.length() == 0) {
                otherType = "燃气收费";
            }
            // 在API开放平台注册时生成
            String APP_ID = wxConfig.getString("app_id");
            // 订单日期(交易发生时间戳，yyyy-MM-dd'T'HH:mm:ss格式)
            String timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());

            // biz_content请求参数的集合

            // 商户编号
            String merId = wxConfig.getString("mer_id");
            // 商户订单号
            String outTradeNo = PayUtil.getOutTradeNo();
            // 支付方式:9-微信；10-支付 宝；
            String paymode = "9";
            //  收单接入方式，5-APP，7-微信公众号，8-支付宝生活号，9-微信小程序
            String accessType = "7";
            // 收单产品协议编号
            String merPrtclNo = wxConfig.getString("merPrtclNo");
            // 交易币种，目前工行只支持使用 人民币（001）支付
            String fee_type = "001";
            // 用户端IP
            String spbillCreateIp = request1.getRemoteAddr();
            // 订单金额，单位为分
            String totalFee = String.valueOf(PayUtil.yuan2FenInt(money));
            // 异步通知商户URL，端口必须 为443或80
            String merUrl = wxConfig.getString("wechatNotify");
            // 商户在微信开放平台注册的APPID，支付方式为微信时不能为空
            String shopAppid = wxConfig.getString("appId");
            // 第三方用户标识，支付宝支付时必输，非支付宝支付的送空字符串
            String unionid = "";
            // 支付方式限定，上送”no_credit“表示不支持信用卡支付；上送“no_balance”表示仅支持银行卡支付；不上送或上送空表示无限制。暂只支持微信公众号
            String paylimit = "";
            // 微信商品描述(微信支付下，body不能为空)
            String body = wxConfig.getString("body");
            // 结果发送类型，取值“0”：无论支付成功或者失败，交易结果都传，"1"，只发送交易成功结果，默认0
            String resultType = "0";
            // “HS”：主动发送交易给商户；“AG”：在交易完成后不通知商户
            String notifyType = "HS";
            // 商户账号，商户入账账号，只能交易时指定。
            String merAcct = wxConfig.getString("mer_acct");
            // 附加数据，在查询API和支付通 知中原样返回
            int len = 127;
            String attachs = attach;
            if(attachs.length() > len) {
                attachs = attachs.substring(0, len);
            }

            CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1.CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1Biz bizContent = new CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1.CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1Biz();
            bizContent.setMer_id(merId);
            bizContent.setOut_trade_no(outTradeNo);
            bizContent.setPay_mode(paymode);
            bizContent.setAccess_type(accessType);
            bizContent.setMer_prtcl_no(merPrtclNo);
            bizContent.setOrig_date_time(timestamp);
            bizContent.setDecive_info(userfilesid);
            bizContent.setBody(body);
            bizContent.setFee_type(fee_type);
            bizContent.setSpbill_create_ip(spbillCreateIp);
            bizContent.setTotal_fee(totalFee);
            bizContent.setMer_url(merUrl);
            bizContent.setShop_appid(shopAppid);
            bizContent.setIcbc_appid(APP_ID);
            bizContent.setOpen_id(openid);
            bizContent.setUnion_id(unionid);
            bizContent.setMer_acct(merAcct);
            bizContent.setAttach(attachs);
            bizContent.setNotify_type(notifyType);
            bizContent.setResult_type(resultType);
            bizContent.setPay_limit(paylimit);
            bizContent.setOrder_apd_inf("");


            // 私钥
            String MY_PRIVATE_KEY = wxConfig.getString("privateKey");
            // 公钥
            String APIGW_PUBLIC_KEY = wxConfig.getString("pubKey");
            // 请求地址
            String requestUrl = wxConfig.getString("requestUrl");
            // 下单参数
            String paramMap = new JSONObject(bizContent).toString();
            log.debug("城然工行下单地址: {},下单参数: {}", requestUrl, paramMap);

            DefaultIcbcClient client = new DefaultIcbcClient(APP_ID, IcbcConstants.SIGN_TYPE_RSA2, MY_PRIVATE_KEY, APIGW_PUBLIC_KEY);
            CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1 request = new CardbusinessAggregatepayB2cOnlineConsumepurchaseRequestV1();
            request.setServiceUrl(requestUrl);
            request.setBizContent(bizContent);
            CardbusinessAggregatepayB2cOnlineConsumepurchaseResponseV1 response;
            try {
                // msgId消息通讯唯一编号，要求每次调用独立生成，APP级唯一
                String msgid = String.valueOf(System.currentTimeMillis());
                response = client.execute(request, msgid);
                JSONObject responseJson = new JSONObject(response);
                log.debug("工行下单返回数据: {}", responseJson.toString());
                if (response.getReturnCode() == 0) {
                    // 保存下单信息到中间表
                    result = responseJson.toString();
                    JSONObject saveOrder = new JSONObject();
                    saveOrder.put("f_out_trade_no", outTradeNo);
                    saveOrder.put("f_attach", attach);
                    saveOrder.put("f_openid", openid);
                    saveOrder.put("f_order_state", "已下单");
                    saveOrder.put("f_order_type", otherType);
                    saveOrder.put("flag", "JsApiChengRan");
                    saveOrder.put("f_trade_type", "JSAPI");
                    saveOrder.put("f_filiale", filiale);
                    saveOrder.put("f_total_fee", totalFee);
                    saveOrder.put("f_userfiles_id", userfilesid);
                    // 保存分公司id
                    JSONObject clientConfig = Config.getClientConfig(filiale);
                    saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                    logicServer.run("savewxreturnxml", saveOrder);
                }
            } catch (IcbcApiException e) {
                e.printStackTrace();
                log.debug("诚然工行下单返回结果异常错误", e);
            }
        } catch (Exception e) {
            log.debug("诚然工行下单异常错误", e);
        }
        return result;
    }


    /**
     * 查询订单是否支付成功
     *
     * @param value
     * @return 订单支付结果
     */
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            // 在API开放平台注册时生成
            String app_id = wxConfig.getString("app_id");

            // biz_content参
            // 商户编号
            String merId = wxConfig.getString("mer_id");
            // 商户订单号
            String outTradeNo = jsonObject.getString("out_trade_no");
            // 操作标志，0-查询；1-关单
            String deal_flag = "0";
            CardbusinessAggregatepayB2cOnlineOrderqryRequestV1.CardbusinessAggregatepayB2cOnlineOrderqryRequestV1Biz bizContent = new CardbusinessAggregatepayB2cOnlineOrderqryRequestV1.CardbusinessAggregatepayB2cOnlineOrderqryRequestV1Biz();
            bizContent.setMer_id(merId);
            bizContent.setOut_trade_no(outTradeNo);
            bizContent.setDeal_flag(deal_flag);
            bizContent.setIcbc_appid(app_id);
            // 私钥
            String MY_PRIVATE_KEY = wxConfig.getString("privateKey");
            // 公钥
            String APIGW_PUBLIC_KEY = wxConfig.getString("pubKey");
            // 查询地址
            String queryUrl = wxConfig.getString("queryUrl");
            // 查询参数
            String paramMap = new JSONObject(bizContent).toString();
            log.debug("城然工行查询地址: {},查询参数: {}", queryUrl, paramMap);
            DefaultIcbcClient client = new DefaultIcbcClient(app_id, IcbcConstants.SIGN_TYPE_RSA2, MY_PRIVATE_KEY, APIGW_PUBLIC_KEY);
            CardbusinessAggregatepayB2cOnlineOrderqryRequestV1 request = new CardbusinessAggregatepayB2cOnlineOrderqryRequestV1();
            request.setBizContent(bizContent);
            request.setServiceUrl(queryUrl);
            CardbusinessAggregatepayB2cOnlineOrderqryResponseV1 response;
            try {
                // msgId消息通讯唯一编号，要求每次调用独立生成，APP级唯一
                String msgid = System.currentTimeMillis() + "";
                response = client.execute(request, msgid);
                JSONObject jsonResponse = new JSONObject(response);
                log.debug("返回信息: {}", jsonResponse.toString());
                if (response.getReturnCode() == 0) {
                    if (!"success".equals(response.getReturnMsg())) {
                        result.put("result_code", "FAIL");
                        result.put("return_msg", response.getReturnMsg());
                        log.debug("查询失败", response.getReturnMsg());
                    }
                    //获取支付状态 0-支付,2-交易状态异常
                    String paystatus = response.getPay_status();
                    if ("0".equals(paystatus)) {
                        result.put("result_code", "SUCCESS");
                        result.put("trade_state", "SUCCESS");
                        // 订单号
                        result.put("transaction_id", response.getOrder_id());
                        // 交易日期
                        result.put("time_end", response.getPay_time());
                        // 交易金额
                        result.put("total_fee", response.getTotal_amt());
                    } else {
                        result.put("result_code", "FAIL");
                        result.put("return_msg", paystatus);
                        log.debug("订单状态不等于已支付：" + paystatus);
                    }
                } else {
                    result.put("result_code", "FAIL");
                    result.put("return_msg", response.getReturnMsg());
                    log.debug("请求结果失败:" + response.getReturnMsg());
                }
            } catch (IcbcApiException e) {
                log.error("操作失败：原因" + e.getMessage());
                result.put("result_code", "FAIL");
                result.put("return_msg", "系统异常");
            }
        } catch (Exception e) {
            result.put("trade_state", "FAIL");
            log.debug("工行查询订单异常：" + e);
        }
        return result.toString();
    }
}
