package com.aote.pay.ceb.xinkang;

import org.apache.commons.codec.binary.Base64;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class SignUtil {
	public static String getSign(String privateKey,String content,String charset){
		String sign = "";
		try {
			// 对私钥做base64解码
			byte[] keyBytes = Base64.decodeBase64(privateKey);
			// 获取签名内容的字节数组
			byte[] contentBytes = content.getBytes(charset);
			PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
			KeyFactory keyFactory = KeyFactory.getInstance("RSA");
			PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
			Signature signature = Signature.getInstance("MD5withRSA");
			signature.initSign(priKey);
			// data为要生成签名的源数据字节数组
			signature.update(contentBytes);
			// 进行两次base64编码
			byte[] encodeBase64 = Base64.encodeBase64(Base64.encodeBase64(signature.sign()));
			sign = new String(encodeBase64);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return sign;
	}

	public static boolean verify(String publicKey, String sign, String content , String charset){
		// 对提供的公钥做base64解码
		byte[] publicKey2 =Base64.decodeBase64(publicKey);
		// 签名需要做两次base64解码
		byte[] signtrue= Base64.decodeBase64(Base64.decodeBase64(sign));
		X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey2);
		try {
			KeyFactory keyFactory = KeyFactory.getInstance("RSA");
			PublicKey pubKey = keyFactory.generatePublic(keySpec);
			Signature signature = Signature.getInstance("MD5withRSA");
			signature.initVerify(pubKey);
			signature.update(content.getBytes(charset));
			return signature.verify(signtrue);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

}
