package com.aote.pay.abc_furuike;

import com.abc.pay.client.ebus.PaymentRequest;
import com.abc.pay.client.ebus.QueryOrderRequest;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.util.PayUtil;
import com.aote.util.WxSign;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 景泰水务农行对接下单接口
 */
@Slf4j
@Component
public class JsApiJingTaiShuiWu implements PaySuper {

    @Autowired
    private LogicServer logicServer;
    

    /**
     * 下单接口(6.3.1 方式 1：通过与农行服务器建立连接访问农行支付平台服务)
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");

        JSONObject result = new JSONObject();
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        try {
            // 交易类型
            String payTypeID = wxConfig.getString("payTypeID");
            // 订单日期
            String orderDate = new SimpleDateFormat("yyyy/MM/dd").format(new Date());
            // 订单时间
            String orderTime = new SimpleDateFormat("HH:mm:ss").format(new Date());
            // 设定交易币种
            String currencyCode = wxConfig.getString("currencyCode");
            // 支付订单编号
            String orderNo = WxSign.getNonceStr();
            // 设定支付账户
            String appId = wxConfig.getString("appId");
            // 分期标识
            String installmentMark = wxConfig.getString("installmentMark");
            // 设定订单说明
            String orderDesc = wxConfig.getString("orderDesc");
            // 设定商品种类
            String commodityType = wxConfig.getString("commodityType");

            PaymentRequest tPaymentRequest = new PaymentRequest();
            // 设定 交易类型
            tPaymentRequest.dicOrder.put("PayTypeID", payTypeID);
            // 设定订单日期 （必要信息 - YYYY/MM/DD）
            tPaymentRequest.dicOrder.put("OrderDate", orderDate);
            // 设定订单时间 （必要信息 - HH:MM:SS）
            tPaymentRequest.dicOrder.put("OrderTime", orderTime);
            // 设定交易币种
            tPaymentRequest.dicOrder.put("CurrencyCode", currencyCode);
            // 设定订单编号 （必要信息）
            tPaymentRequest.dicOrder.put("OrderNo", orderNo);
            // 设定交易金额
            tPaymentRequest.dicOrder.put("OrderAmount", money);
            // 分期标识
            tPaymentRequest.dicOrder.put("InstallmentMark", installmentMark);
            // 设置商品种类
            tPaymentRequest.dicOrder.put("CommodityType", commodityType);
            // 设定商品名称
            String productName = wxConfig.getString("productName");
            LinkedHashMap orderItem = new LinkedHashMap();
            orderItem.put("ProductName", productName);//商品名称
            tPaymentRequest.orderitems.put(1, orderItem);

            // 设定支付方式
            String paymentType = "A";
            // 设定交易渠道
            String paymentLinkType = "2";
            // 设定通知方式
            String notifyType = "1";
            // 设定通知URL地址
            String resultNotifyURL = wxConfig.getString("resultNotifyURL");
            // 设定交易是否支持向二级商户入账
            String isBreakAccount = "0";
            // 设定支付方式
            tPaymentRequest.dicRequest.put("PaymentType", paymentType);
            // 设定支付接入方式
            tPaymentRequest.dicRequest.put("PaymentLinkType", paymentLinkType);
            // 设定通知方式
            tPaymentRequest.dicRequest.put("NotifyType", notifyType);
            // 设定通知URL地址
            tPaymentRequest.dicRequest.put("ResultNotifyURL", resultNotifyURL);
            // 设定交易是否支持向二级商户入账
            tPaymentRequest.dicRequest.put("IsBreakAccount", isBreakAccount);

            com.aote.pay.abc_furuike.JSONObject response = new com.aote.pay.abc_furuike.JSONObject(tPaymentRequest.postRequest());

            String s = response.toString();
            log.debug("查看返回结果: {}", s);
            if ("0000".equals(response.GetKeyValue("ReturnCode"))) {
                String paymentURL = response.GetKeyValue("PaymentURL");
                String oneQRForAll = response.GetKeyValue("OneQRForAll");
                result.put("paymentURL", paymentURL);
                result.put("oneQRForAll", oneQRForAll);
                // 保存下单信息到中间表
                JSONObject saveOrder = new JSONObject();
                saveOrder.put("f_out_trade_no", orderNo);
                saveOrder.put("f_attach", attach);
                saveOrder.put("f_openid", openid);
                saveOrder.put("flag", "JsApiJingTaiShuiWu");
                saveOrder.put("f_order_state", "已下单");
                saveOrder.put("f_order_type", "燃气收费");
                saveOrder.put("f_trade_type", "JSAPI");
                saveOrder.put("f_filiale", filiale);
                saveOrder.put("f_total_fee", PayUtil.yuan2FenInt(money));
                // 保存分公司id
                JSONObject clientConfig = Config.getClientConfig(filiale);
                saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                logicServer.run("savewxreturnxml", saveOrder);
            }
        } catch (Exception e) {
            log.debug("操作失败, 原因: {}", e);
        }
        return result.toString();

    }

    @Override
    public String orderStatus(String value) {

        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            // 订单号
            String outTradeNo = jsonObject.getString("out_trade_no");
            // 分公司
            String filiale = jsonObject.getString("f_filiale");

            // 设定交易类型
            String payTypeID = "ImmediatePay";
            // 设定查询方式 1-详细查询 0-简略查询
            String queryDetail = "1";
            QueryOrderRequest tQueryRequest = new QueryOrderRequest();
            tQueryRequest.queryRequest.put("PayTypeID", payTypeID);    //设定交易类型
            tQueryRequest.queryRequest.put("OrderNo", outTradeNo);    //设定订单编号 （必要信息）
            tQueryRequest.queryRequest.put("QueryDetail", queryDetail);//设定查询方式

            com.aote.pay.abc_furuike.JSONObject json = new com.aote.pay.abc_furuike.JSONObject(tQueryRequest.postRequest());

            if ("0000".equals(json.GetKeyValue("ReturnCode"))) {
                //4、获取结果信息
                String orderInfo = json.GetKeyValue("Order");
                if (orderInfo.length() < 0) {
                    log.debug("查询结果为空");
                    result.put("查询结果为空", "查询不到信息");
                }
                // 通过tBase64进行解密
                com.abc.pay.client.Base64 tBase64 = new com.abc.pay.client.Base64();
                String orderDetail = new String(tBase64.decode(orderInfo));
                json.setJsonString(orderDetail);
                log.debug("查看查询返回信息:" + orderDetail);

                LinkedHashMap linkedHashMap = new LinkedHashMap();
                linkedHashMap = json.GetArrayValue("OrderItems");
                if (linkedHashMap.size() == 0) {
                    log.debug("查询明细结果为空");
                    result.put("error", "查询明细结果为空");
                }
                Iterator iter = linkedHashMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry) iter.next();
                    log.debug("key:" + entry.getKey() + "  value" + entry.getValue());
                }

                // 获取支付状态 01-未支付 02-未回应 03-微信和支付宝支付成功 04-微信、支付宝支付时，表示农行清算成功；农行支付时，表示农行支付成功 05-已退款
                String status = json.GetKeyValue("Status");
                result.put("trade_state", status);
                if ("03".equals(status) || "04".equals(status)) {
                    //获取订单日期
                    String orderDate = json.GetKeyValue("OrderDate");
                    //获取订单时间
                    String orderTime = json.GetKeyValue("OrderTime");
                    String dateTime = orderDate + " " + orderTime;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    String time = "";
                    try {
                        Date parse = sdf.parse(dateTime);
                        SimpleDateFormat sdft = new SimpleDateFormat("yyyyMMddHHmmss");
                        time = sdft.format(parse);
                    } catch (Exception e) {
                        log.debug("时间格式转换错误：" + e.getMessage());
                        e.printStackTrace();
                    }
                    // 订单金额
                    String orderAmount = json.GetKeyValue("OrderAmount");
                    // 订单号
                    String thirdOrderNo = json.GetKeyValue("iRspRef");
                    result.put("transaction_id", thirdOrderNo);
                    result.put("total_fee", PayUtil.yuan2FenInt(orderAmount));
                    result.put("time_end", time);
                    result.put("trade_state", "SUCCESS");
                } else {
                    log.debug("订单状态不等于已支付：" + status);
                    result.put("error", "订单状态不等于已支付");
                }
            } else {
                log.debug("请求结果失败");
                result.put("error", "请求结果失败");
            }
        } catch (Exception e) {
            log.debug("操作失败, 原因: {}", e);
            result.put("error", "系统异常");
        }
        return result.toString();
    }
}

