package com.aote.rs;


import oracle.jdbc.proxy.annotation.OnError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.websocket.*;
import javax.websocket.server.ServerEndpoint;
import java.io.*;
import java.net.*;


@Component
@ServerEndpoint("/webSocket")
public class WebSocket {
    static Logger log = LoggerFactory.getLogger(WebSocket.class);

//    String socketIP = "113.140.20.122";
//    int socketPort = 2002;
    String socketIP = "192.168.40.3";
    int socketPort = 5002;

    @OnOpen
    public void onOpen(Session session) {
        log.debug("onOpen:" + session.getId());
    }

    @OnClose
    public void OnClose(Session session) {
        log.debug("OnClose:" + session.getId());
    }

    @OnMessage
    public void onMessage(String data, Session session) {
        log.debug("onMessage:" + session.getId() + ", data:" + data);
        sendSocket(data, session);
    }

    @OnError
    public void onError(Session session, Throwable e) {
        log.debug("onError:" + session.getId());
    }

    public void sendMessage(Session session, String message) throws IOException {
        log.debug("sendMessage:" + session.getId() + ", message:" + message);
        session.getBasicRemote().sendText(message);
    }


    public void sendSocket(String data, Session session) {
        Socket socket = new Socket();
        BufferedWriter writer = null;
        BufferedReader br = null;
        String line;
        StringBuilder result = new StringBuilder();
        try {
            socket.connect(new InetSocketAddress(socketIP, socketPort), 30000);
            socket.setSoTimeout(120000);
            br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter pw = new PrintWriter(socket.getOutputStream());
            pw.print(data);
            pw.flush();
            while ((line = br.readLine()) != null) {
                result.append(line);
            }
            sendMessage(session, result.toString());
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                socket.close();
                if (br != null) {
                    br.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

}
