package com.aote.pay.rcb.ankangyihua;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.sql.SqlServer;
import com.aote.util.PayUtil;
import com.aote.util.WxSign;
import com.aote.weixin.Config;
import com.google.common.io.Files;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TreeMap;


@Slf4j
@Component
public class JsApiAKYHRcb implements PaySuper , RefundSuper {
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private SqlServer sqlServer;

    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String newAttach = json.getJSONObject("attach").toString();
        JSONObject attach = json.getJSONObject("attach");
        JSONObject newAttachParam = new JSONObject();
        log.debug("下单attach=" + attach);
        if (attach.has("f_type")){
            if ("siteOtherFee".equals(attach.getString("f_type"))){
                newAttachParam.put("f_userfiles_id",attach.optString("f_userfiles_id", ""));
                newAttachParam.put("money",attach.optString("money", ""));
                newAttach = newAttachParam.toString();
            }
        }
        String filiale = json.getString("filiale");
        String userfilesid = json.optString("userfilesid","");
        String orderType = json.optString("orderType","燃气收费");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            // 固定参数
            TreeMap<String, String> postmap = new TreeMap<String, String>();    // 请求参数的map
            String timestamp = WxSign.getTimeStamp();
            postmap.put("open_id", wxConfig.getString("OPEN_ID"));
            postmap.put("timestamp", timestamp);
            // 这个订单金额元转为分
            int totalAmount = PayUtil.yuan2FenInt(money);
            String notifyUrl = wxConfig.getString("wechatNotify");
            TreeMap<String, Object> datamap = new TreeMap<String, Object>();    // data参数的map
            // 系统订单号
            String outTradeNo = PayUtil.getOrderNoByNumber();
            datamap.put("out_no", outTradeNo);
            datamap.put("pmt_tag", wxConfig.getString("pmtTag"));
            datamap.put("pmt_name", "信合微信支付");
            datamap.put("ord_name", orderType+"-"+userfilesid);
            datamap.put("original_amount", totalAmount);
            datamap.put("discount_amount",0);
            datamap.put("ignore_amount", 0);
            datamap.put("trade_amount", totalAmount);
            datamap.put("tag", newAttach);
            datamap.put("notify_url", notifyUrl);
            datamap.put("JSAPI",1);
            String appid = wxConfig.getString("appId");
            datamap.put("sub_appid",appid);
            datamap.put("sub_openid",openid);
            String PayUrl = wxConfig.getString("PayUrl");
            String openKey = wxConfig.getString("OPEN_KEY");
            /**
             * 1 data字段内容进行AES加密，再二进制转十六进制(bin2hex)
             */
            TLinx2Util.handleEncrypt(datamap, postmap,openKey);

            /**
             * 2 请求参数签名 按A~z排序，串联成字符串，先进行sha1加密(小写)，再进行md5加密(小写)，得到签名
             */
            TLinx2Util.handleSignKey(postmap,openKey);
            log.debug("安康逸华农商银行下单地址: {},下单bogy参数: {}", PayUrl, postmap);

            String res ;
            try {
                /**
                 * 3 请求、响应
                 */
                res = TLinx2Util.handlePost(postmap, PayUrl);
                log.debug("请求结果：" + res);

                /**
                 * 4 验签  有data节点时才验签
                 */
                com.alibaba.fastjson.JSONObject respObject = com.alibaba.fastjson.JSONObject.parseObject(res);
                log.debug("====响应错误码：" + respObject.get("errcode"));
                log.debug("====响应错误提示：" + respObject.get("msg"));
                Object dataStr = respObject.get("data");
                // 业务代码
                if (!res.isEmpty() && (dataStr != null)) {
                    if (TLinx2Util.verifySign(respObject,openKey)) {
                        /**
                         * 5 AES解密，并hex2bin
                         */
                        String respData = TLinxAESCoder.decrypt(dataStr.toString(), openKey);
                        log.debug("=================响应data内容= " + respData);
                        JSONObject resData = new JSONObject(respData);
                        JSONObject saveOrder = new JSONObject();
                        saveOrder.put("f_out_trade_no", outTradeNo);
                        saveOrder.put("f_attach", attach);
                        saveOrder.put("f_openid", openid);
                        saveOrder.put("f_order_state", "已下单");
                        saveOrder.put("f_order_type", orderType);
                        saveOrder.put("flag", "JsApiAKYHRcb");
                        saveOrder.put("f_trade_type", "JSAPI");
                        // 平台订单号
//                        saveOrder.put("tradeNo",resData.getString("trade_no"));
                        saveOrder.put("f_filiale", filiale);
                        saveOrder.put("f_total_fee", String.valueOf(totalAmount));
                        saveOrder.put("f_userfiles_id", userfilesid);
                        // 保存分公司id
                        JSONObject clientConfig = Config.getClientConfig(filiale);
                        saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                        logicServer.run("savewxreturnxml", saveOrder);

                        result.put("code", 200);
                        result.put("msg", "SUCCESS");
                        result.put("out_trade_no", outTradeNo);
                        JSONObject tranPackage = new JSONObject();
                        tranPackage.put("appId",resData.getString("appId"));
                        tranPackage.put("timeStamp",resData.getString("timeStamp"));
                        tranPackage.put("nonceStr",resData.getString("nonceStr"));
                        tranPackage.put("signType",resData.getString("signType"));
                        tranPackage.put("package",resData.getString("package"));
                        tranPackage.put("paySign",resData.getString("paySign"));
                        result.put("tranPackage",tranPackage);
                    } else {
                        log.debug("====验签失败：" + respObject.get("msg"));
                        result.put("code",  501);
                        result.put("error", "下单失败，失败原因:验签失败");
                    }
                }else {
                    result.put("code",  respObject.get("errcode"));
                    result.put("error", "下单失败，失败原因:" + respObject.get("msg").toString());
                }
            } catch (Exception e) {
                log.debug("请求响应错误");
                result.put("code",  500);
                result.put("result_msg", "请求响应错误");
                result.put("err_msg", e.getMessage());
                throw new RuntimeException("下单请求安康逸华农商银行未正常响应");
            }
        }catch (Exception e) {
            log.debug("安康逸华农商银行下单异常错误", e);
        }
        return result.toString();
    }

    public String microPay(JSONObject json) {
        log.debug("安康逸华农商银行收到付款码下单支付请求:{}", json);
        String money = json.getString("money");
        String filiale = json.getString("filiale");
        String userFilesId = json.optString("f_userfiles_id", "");
        String newAttach = json.getJSONObject("attach").toString();
        JSONObject attach = json.getJSONObject("attach");
        JSONObject newAttachParam = new JSONObject();
        log.debug("下单attach=" + attach);
        if (attach.has("f_type")){
            if ("siteOtherFee".equals(attach.getString("f_type"))){
                newAttachParam.put("f_userfiles_id",attach.optString("f_userfiles_id", ""));
                newAttachParam.put("money",attach.optString("money", ""));
                newAttach = newAttachParam.toString();
            }
        }
        // 扫码支付授权码
        String authCode =  json.getString("auth_code");
        // 什么钱？
        String orderType = json.optString("orderType","燃气收费");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject clientConfig = Config.getClientConfig(filiale);
        JSONObject result = new JSONObject();
        // 商户订单号  系统生成  这个是30位的要截取一下
        String outTradeNo = PayUtil.getOrderNoByNumber();
        try {
            // 固定参数
            TreeMap<String, String> postmap = new TreeMap<String, String>();    // 请求参数的map
            String timestamp = WxSign.getTimeStamp();
            postmap.put("open_id", wxConfig.getString("OPEN_ID"));
            postmap.put("timestamp", timestamp);
            // 这个订单金额元转为分
            int totalAmount = PayUtil.yuan2FenInt(money);
            String notifyUrl = wxConfig.getString("wechatNotify");
            TreeMap<String, Object> datamap = new TreeMap<String, Object>();    // data参数的map
            // 系统订单号
            datamap.put("out_no", outTradeNo);
            datamap.put("pmt_tag",  wxConfig.getString("pmtTag"));
            datamap.put("pmt_name", "信合微信支付");
            datamap.put("ord_name", orderType+"-"+userFilesId);
            datamap.put("original_amount", totalAmount);
            datamap.put("discount_amount",0);
            datamap.put("ignore_amount", 0);
            datamap.put("trade_amount", totalAmount);
            datamap.put("tag", newAttach);
            datamap.put("notify_url", notifyUrl);
            datamap.put("auth_code",authCode);
            String openKey = wxConfig.getString("OPEN_KEY");
            /**
             * 1 data字段内容进行AES加密，再二进制转十六进制(bin2hex)
             */
            TLinx2Util.handleEncrypt(datamap, postmap,openKey);

            /**
             * 2 请求参数签名 按A~z排序，串联成字符串，先进行sha1加密(小写)，再进行md5加密(小写)，得到签名
             */
            TLinx2Util.handleSignKey(postmap,openKey);
            // 扫码下单接口
            String microPayUrl = wxConfig.getString("microPayUrl");
            log.debug("安康逸华农商银行查询扫码下单接口: {},下单参数: {}", microPayUrl, datamap);
            String res ;
            /**
             * 3 请求、响应
             */
            res = TLinx2Util.handlePost(postmap, microPayUrl);
            log.debug("请求结果：" + res);
            /**
             * 4 验签  有data节点时才验签
             */
            com.alibaba.fastjson.JSONObject respObject = com.alibaba.fastjson.JSONObject.parseObject(res);
            log.debug("====响应错误码：" + respObject.get("errcode"));
            log.debug("====响应错误提示：" + respObject.get("msg"));
            Object dataStr = respObject.get("data");
            if (!res.isEmpty() && (dataStr != null)) {
                if (TLinx2Util.verifySign(respObject,openKey)) {
                    String respData = TLinxAESCoder.decrypt(dataStr.toString(), openKey);
                    log.debug("=================响应data内容= " + respData);
                    JSONObject saveOrder = new JSONObject();
                    JSONObject resData = new JSONObject(respData);
                    if ("1".equals(resData.getString("status"))) {
                        // 支付成功了
                        result.put("result_code", "SUCCESS");
                        result.put("result_msg", "支付结果未知");
                        result.put("trade_state", "SUCCESS");
                        result.put("transaction_id", resData.getString("ord_no"));
                        // 交易时间
                        result.put("time_end", DateUtil.format(DateUtil.parse(resData.getString("trade_pay_time"), DatePattern.NORM_DATETIME_PATTERN), DatePattern.PURE_DATETIME_PATTERN));
                        saveOrder.put("f_time_end", DateUtil.format(DateUtil.parse(resData.getString("trade_pay_time"), DatePattern.NORM_DATETIME_PATTERN), DatePattern.PURE_DATETIME_PATTERN));
                        result.put("out_trade_no", resData.getString("outTradeNo"));
                        saveOrder.put("f_order_state", "已支付");
                    } else if ("9".equals(resData.getString("status"))) {
                        result.put("result_code", "FAIL");
                        result.put("result_msg",  "订单等待用户输入密码确认");
                        saveOrder.put("f_order_state", "待查询");
                    } else if ("2".equals(resData.getString("status"))) {
                        result.put("result_code", "FAIL");
                        result.put("result_msg",  "订单待支付");
                        saveOrder.put("f_order_state", "待查询");
                    } else if ("4".equals(resData.getString("status"))) {
                        result.put("result_code", "FAIL");
                        result.put("result_msg",  "订单待支付");
                        saveOrder.put("f_order_state", "待查询");
                    } else {
                        result.put("result_code", "FAIL");
                        result.put("result_msg",  "订单状态未知");
                        saveOrder.put("f_order_state", "待查询");
                    }
                    saveOrder.put("f_out_trade_no", outTradeNo);
                    saveOrder.put("f_attach", attach);
                    saveOrder.put("f_order_type", orderType);
                    saveOrder.put("flag", "JsApiAKYHRcb");
                    saveOrder.put("f_trade_type", "MICROPAY");
                    // 平台订单号
//                    saveOrder.put("tradeNo",resData.getString("trade_no"));
                    saveOrder.put("f_filiale", filiale);
                    saveOrder.put("f_total_fee", String.valueOf(totalAmount));
                    saveOrder.put("f_userfiles_id", userFilesId);
                    saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                    logicServer.run("savewxreturnxml", saveOrder);
                } else {
                    result.put("result_code", "FAIL");
                    result.put("result_msg",  "验签失败");
                    result.put("trade_state", "FAIL");
                }
            } else {
                result.put("result_code", "FAIL");
                result.put("result_msg",  "支付确认失败");
                result.put("trade_state", "FAIL");
            }
        } catch (Exception e) {
            log.debug("付款码下单异常", e);
        }
        return result.toString();
    }
    public String codePay(JSONObject json) {
        log.debug("安康逸华农商银行收到二维码下单支付请求:{}", json);
        String money = json.getString("money");
        String filiale = json.getString("filiale");
        String userFilesId = json.optString("f_userfiles_id", "");
        String newAttach = json.getJSONObject("attach").toString();
        JSONObject attach = json.getJSONObject("attach");
        JSONObject newAttachParam = new JSONObject();
        log.debug("下单attach=" + attach);
        if (attach.has("f_type")){
            if ("siteOtherFee".equals(attach.getString("f_type"))){
                newAttachParam.put("f_userfiles_id",attach.optString("f_userfiles_id", ""));
                newAttachParam.put("money",attach.optString("money", ""));
                newAttach = newAttachParam.toString();
            }
        }
        String orderType = json.optString("orderType","燃气收费");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject clientConfig = Config.getClientConfig(filiale);
        JSONObject result = new JSONObject();
        // 商户订单号  系统生成  这个是30位的要截取一下
        String outTradeNo = PayUtil.getOrderNoByNumber();
        try {

            // 固定参数
            TreeMap<String, String> postmap = new TreeMap<String, String>();    // 请求参数的map
            String timestamp = WxSign.getTimeStamp();
            postmap.put("open_id", wxConfig.getString("OPEN_ID"));
            postmap.put("timestamp", timestamp);
            // 这个订单金额元转为分
            int totalAmount = PayUtil.yuan2FenInt(money);
            String notifyUrl = wxConfig.getString("codeNotifyUrl");
            TreeMap<String, Object> datamap = new TreeMap<String, Object>();    // data参数的map
            // 系统订单号
            datamap.put("out_no", outTradeNo);
            datamap.put("pmt_tag", wxConfig.getString("pmtTag"));
            datamap.put("pmt_name", "信合微信支付");
            datamap.put("ord_name", orderType+"-"+userFilesId);
            datamap.put("original_amount", totalAmount);
            datamap.put("discount_amount",0);
            datamap.put("ignore_amount", 0);
            datamap.put("trade_amount", totalAmount);
            datamap.put("tag", newAttach);
            datamap.put("notify_url", notifyUrl);
            String openKey = wxConfig.getString("OPEN_KEY");
            /**
             * 1 data字段内容进行AES加密，再二进制转十六进制(bin2hex)
             */
            TLinx2Util.handleEncrypt(datamap, postmap,openKey);

            /**
             * 2 请求参数签名 按A~z排序，串联成字符串，先进行sha1加密(小写)，再进行md5加密(小写)，得到签名
             */
            TLinx2Util.handleSignKey(postmap,openKey);

            // 扫码下单接口
            String codePayUrl = wxConfig.getString("codePayUrl");

            log.debug("安康逸华农商银行二维码下单接口: {},下单参数: {}", codePayUrl, datamap);
            String res ;
            res = TLinx2Util.handlePost(postmap, codePayUrl);
            log.debug("请求结果：" + res);
            /**
             * 4 验签  有data节点时才验签
             */
            com.alibaba.fastjson.JSONObject respObject = com.alibaba.fastjson.JSONObject.parseObject(res);
            log.debug("====响应错误码：" + respObject.get("errcode"));
            log.debug("====响应错误提示：" + respObject.get("msg"));
            Object dataStr = respObject.get("data");
            if (!res.isEmpty() && (dataStr != null)) {
                if (TLinx2Util.verifySign(respObject,openKey)) {
                    String respData = TLinxAESCoder.decrypt(dataStr.toString(), openKey);
                    log.debug("=================响应data内容= " + respData);
                    JSONObject resData = new JSONObject(respData);
                    JSONObject orderData = new JSONObject();
                    orderData.put("f_out_trade_no", outTradeNo);
                    orderData.put("f_attach", attach);
                    orderData.put("f_order_state", "已下单");
                    // 设置超时时间 (当前时间加100秒)
                    Date afterDate = new Date(System.currentTimeMillis() + 120000);
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String timeOut = formatter.format(afterDate);
                    log.debug("超时时间"+timeOut);
                    orderData.put("f_time_out", timeOut);
                    orderData.put("f_order_type", orderType);
                    orderData.put("flag", "JsApiAKYHRcb");
                    orderData.put("f_trade_type", "NATIVE");
                    orderData.put("f_filiale", filiale);
                    orderData.put("f_total_fee", String.valueOf(totalAmount));
                    orderData.put("f_userfiles_id", userFilesId);
                    orderData.put("f_orgid", clientConfig.get("orgStr"));
                    // 支付成功了
                    if (resData.has("trade_qrcode")){
                        result.put("code", 200);
                        result.put("result_msg", "二维码下单成功");
                        result.put("url", resData.getString("trade_qrcode"));
                        logicServer.run("savewxreturnxml", orderData);
                    } else {
                        result.put("code", 500);
                        result.put("result_msg",  "二维码下单失败");
                    }
                } else {
                    result.put("code", 500);
                    result.put("result_msg",  "二维码下单失败");
                }
            } else {
                result.put("code", 500);
                result.put("result_msg",  "二维码下单失败");
            }
        } catch (Exception e) {
            log.debug("二维码下单异常", e);
        }
        return result.toString();
    }
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            // 固定参数
            TreeMap<String, String> postmap = new TreeMap<String, String>();    // 请求参数的map

            String timestamp = WxSign.getTimeStamp();
            postmap.put("open_id", wxConfig.getString("OPEN_ID"));
            postmap.put("timestamp", timestamp);
            // 商户订单号
            String outTradeNo = jsonObject.getString("out_trade_no");
            TreeMap<String, String> datamap = new TreeMap<String, String>();    // data参数的map

            datamap.put("out_no", outTradeNo);
            datamap.put("ord_no", "");
            // 查询订单结果接口
            String QueryUrl = wxConfig.getString("QueryUrl");
            String openKey = wxConfig.getString("OPEN_KEY");
            /**
             * 1 data字段内容进行AES加密，再二进制转十六进制(bin2hex)
             */
            TLinx2Util.handleEncrypt(datamap, postmap, openKey);

            /**
             * 2 请求参数签名 按A~z排序，串联成字符串，先进行sha1加密(小写)，再进行md5加密(小写)，得到签名
             */
            TLinx2Util.handleSignKey(postmap,openKey);
            log.debug("安康逸华农商银行查询地址: {},查询dataParam参数: {}", QueryUrl, datamap);
            String res ;

            res = TLinx2Util.handlePost(postmap, QueryUrl);
            log.debug("请求结果：" + res);
            com.alibaba.fastjson.JSONObject respObject = com.alibaba.fastjson.JSONObject.parseObject(res);

            log.debug("====响应错误码：" + respObject.get("errcode"));
            log.debug("====响应错误提示：" + respObject.get("msg"));
            Object dataStr = respObject.get("data");
            if (!res.isEmpty() || (dataStr != null)) {
                if (TLinx2Util.verifySign(respObject,openKey)) {
                    /**
                     * 5 AES解密，并hex2bin
                     */
                    String respData = TLinxAESCoder.decrypt(dataStr.toString(), openKey);
                    log.debug("=================响应data内容= " + respData);
                    JSONObject redData = new JSONObject(respData);
                    if ("1".equals(redData.getString("status"))) {
                        // 支付成功了
                        result.put("result_code", "SUCCESS");
                        result.put("trade_state", "SUCCESS");
                        result.put("transaction_id", redData.getString("ord_no"));
                        // 交易时间
                        result.put("time_end", DateUtil.format(DateUtil.parse(redData.getString("trade_pay_time"), DatePattern.NORM_DATETIME_PATTERN), DatePattern.PURE_DATETIME_PATTERN));
                        result.put("total_fee", redData.opt("trade_amount"));
                    } else if ("9".equals(redData.getString("status"))) {
                        result.put("result_code", "FAIL");
                        result.put("result_msg",  "订单等待用户输入密码确认");
                    } else if ("2".equals(redData.getString("status"))) {
                        result.put("result_code", "FAIL");
                        result.put("result_msg",  "订单待支付");
                    } else if ("4".equals(redData.getString("status"))) {
                        result.put("result_code", "FAIL");
                        result.put("result_msg",  "订单待支付");
                    } else {
                        result.put("result_code", "FAIL");
                        result.put("result_msg",  "订单状态未知");
                    }
                } else {
                    result.put("result_code", "FAIL");
                    result.put("result_msg",  "验签失败");
                }
            } else {
                result.put("result_code", "FAIL");
                result.put("result_msg",  respObject.getString("msg"));
            }
            } catch (Exception e) {
                log.debug("安康逸华农商银行查询订单异常", e);
                result.put("result_code", "FAIL");
                result.put("trade_state", "FAIL");
                result.put("result_msg", e.getMessage());
            }
            log.debug("查询订单返回: {}", result.toString());
            return result.toString();
    }

    @Override
    public String refund(JSONObject json) {
        String filiale = json.getString("f_filiale");
        Integer id = json.getInt("id");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {

            // 退款需要新的退款单号
            String txnOrderId = PayUtil.getOutTradeNo();
            TreeMap<String, String> postmap = new TreeMap<String, String>();    // 请求参数的map

            String timestamp = WxSign.getTimeStamp();
            postmap.put("open_id", wxConfig.getString("OPEN_ID"));
            postmap.put("timestamp", timestamp);
            // 商户订单号
            TreeMap<String, String> datamap = new TreeMap<String, String>();    // data参数的map
            // 商户订单号，商户端保证唯一
            String outTradeNo = json.getString("out_trade_no");

            String refundAmount = json.getString("f_total_fee");
            datamap.put("out_no", outTradeNo);
            datamap.put("refund_out_no", txnOrderId);
            datamap.put("refund_ord_name", "退款");
            datamap.put("refund_amount", refundAmount);
            datamap.put("shop_pass", TLinxSHA1.SHA1(wxConfig.optString("shop_pass","123456")));

            String refundUrl = wxConfig.getString("refundUrl");
            String openKey = wxConfig.getString("OPEN_KEY");
            /**
             * 1 data字段内容进行AES加密，再二进制转十六进制(bin2hex)
             */
            TLinx2Util.handleEncrypt(datamap, postmap, openKey);

            /**
             * 2 请求参数签名 按A~z排序，串联成字符串，先进行sha1加密(小写)，再进行md5加密(小写)，得到签名
             */
            TLinx2Util.handleSignKey(postmap,openKey);

            log.debug("安康逸华农商银行退款地址: {},退款参数: {}", refundUrl, datamap);
            try {
                String res ;
                /**
                 * 3 请求、响应
                 */
                res = TLinx2Util.handlePost(postmap, refundUrl);
                log.debug("请求结果：" + res);
                /**
                 * 4 验签  有data节点时才验签
                 */
                com.alibaba.fastjson.JSONObject respObject = com.alibaba.fastjson.JSONObject.parseObject(res);

                System.out.println("====响应错误码：" + respObject.get("errcode"));
                System.out.println("====响应错误提示：" + respObject.get("msg"));
                Object dataStr = respObject.get("data");

                log.debug("安康逸华农商银行退款返回数据: {}", respObject);
                if (!res.isEmpty() && (dataStr != null)) {
                    if (TLinx2Util.verifySign(respObject,openKey)) {
                        /**
                         * 5 AES解密，并hex2bin
                         */
                        String respData = TLinxAESCoder.decrypt(dataStr.toString(), openKey);
                        JSONObject redData = new JSONObject(respData);
                        if ("1".equals(redData.getString("status"))) {
                            result.put("result_msg", "退款中");
                            result.put("trade_state", "SUCCESS");
                            this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='退款中', f_refund_id = '"+ txnOrderId+"' where id = '" + id + "'");
                        } else {
                            result.put("result_msg", "退款失败");
                            result.put("trade_state", "FAIL");
                        }
                    } else {
                        result.put("result_msg", "退款失败");
                        result.put("trade_state", "FAIL");
                    }
                } else {
                    result.put("result_msg", "退款失败");
                    result.put("trade_state", "FAIL");
                }
            } catch (Exception var9) {
                var9.printStackTrace();
            }
        } catch (Exception e) {
            log.debug("安康逸华农商银行退款异常错误", e);
        }
        return result.toString();
    }


    /**
     * 查询订单是否退款成功
     *
     * @param value
     * @return 订单退款结果
     */
    @Override
    public String refundOrderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询退款订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));

            // 商户订单号
            String outTradeNo = jsonObject.getString("out_trade_no");
            String refundId = jsonObject.getString("f_refund_id");
            Integer id = jsonObject.getInt("id");
            // 固定参数
            TreeMap<String, String> postmap = new TreeMap<String, String>();    // 请求参数的map

            String timestamp = WxSign.getTimeStamp();
            postmap.put("open_id", wxConfig.getString("OPEN_ID"));
            postmap.put("timestamp", timestamp);
            // 商户订单号
            TreeMap<String, String> datamap = new TreeMap<String, String>();    // data参数的map

            datamap.put("out_no", refundId);
            datamap.put("ord_no", "");
            // 查询订单结果接口
            // 下单地址
            String queryUrl = wxConfig.getString("queryRefundUrl");
            String openKey = wxConfig.getString("OPEN_KEY");
            /**
             * 1 data字段内容进行AES加密，再二进制转十六进制(bin2hex)
             */
            TLinx2Util.handleEncrypt(datamap, postmap, openKey);

            /**
             * 2 请求参数签名 按A~z排序，串联成字符串，先进行sha1加密(小写)，再进行md5加密(小写)，得到签名
             */
            TLinx2Util.handleSignKey(postmap,openKey);

            log.debug("安康逸华农商银行退款结果查询地址: {},查询参数: {}", queryUrl, datamap);

            try {
                String res ;
                res = TLinx2Util.handlePost(postmap, queryUrl);
                log.debug("请求结果：" + res);
                com.alibaba.fastjson.JSONObject respObject = com.alibaba.fastjson.JSONObject.parseObject(res);
                log.debug("安康逸华农商银行退款结果查询返回信息: {}", respObject);
                log.debug("====响应错误码：" + respObject.get("errcode"));
                log.debug("====响应错误提示：" + respObject.get("msg"));
                Object dataStr = respObject.get("data");
                if (!res.isEmpty() || (dataStr != null)) {
                    if (TLinx2Util.verifySign(respObject,openKey)) {
                        /**
                         * 5 AES解密，并hex2bin
                         */
                        String respData = TLinxAESCoder.decrypt(dataStr.toString(), openKey);
                        log.debug("=================响应data内容= " + respData);
                        JSONObject redData = new JSONObject(respData);
                        if ("1".equals(redData.getString("status"))) {
                            // 交易时间
                            result.put("time_end", DateUtil.format(DateUtil.parse(redData.getString("trade_pay_time"), DatePattern.NORM_DATETIME_PATTERN), DatePattern.PURE_DATETIME_PATTERN));
                            result.put("total_fee", redData.opt("trade_amount"));
                            this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已退款' where id = '" + id + "'");
                            this.sqlServer.runSQL("update t_bank_payment set f_state ='无效' where f_trade_number = '"+ outTradeNo +"'");
                            result.put("result_msg", "退款成功");
                            // 订单号
                            result.put("out_trade_no", outTradeNo);
                            result.put("f_refund_id", refundId);
                            // 交易日期
                            log.debug(result.toString());
                        } else {
                            result.put("fail_msg", respObject.get("msg"));
                            result.put("return_msg", "退款处理中");
                            result.put("trade_state", "FAIL");
                            log.debug("订单状态不等于全部退款：" + redData.getString("status"));
                        }
                    } else {
                        this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已支付' where id = '" + id + "'");
                        result.put("trade_state", "FAIL");
                        result.put("return_msg", "退款失败");
                    }
                } else {
                    this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已支付' where id = '" + id + "'");
                    result.put("trade_state", "FAIL");
                    result.put("return_msg", "退款失败");
                }
            } catch (Exception var9) {
                this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已支付' where id = '" + id + "'");
                log.error("操作失败：原因" + var9.getMessage());
                result.put("return_msg", "系统异常");
                var9.printStackTrace();
            }
        } catch (Exception e) {
            result.put("return_msg", "查询失败");
            log.debug("农商银行查询订单异常：" + e);
        }
        return result.toString();
    }

    @Override
    public JSONObject getRecordFile(JSONObject json) {
        String filiale = json.getString("f_filiale");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            // 下载对账文件地址
            String getFileUrl =  wxConfig.getString("getFileUrl");
            String pass = wxConfig.getString("PASS");
            // 固定参数
            TreeMap<String, String> postmap = new TreeMap<String, String>();    // 请求参数的map
            // 默认是查前一天
            Calendar cal = Calendar.getInstance();
            cal.add(Calendar.DATE,-1);
            String billdate = new SimpleDateFormat( "yyyy-MM-dd").format(cal.getTime());
            String timestamp = WxSign.getTimeStamp();
            postmap.put("timestamp", timestamp);
            postmap.put("scr_id", wxConfig.getString("SCR_ID"));
            postmap.put("rand_str", RandomStringUtils.randomAlphanumeric(32));
            postmap.put("day", json.optString("day",billdate));
            /**
             * 1 请求参数签名
             *   1) 把所有参数加上 pass=用户登录密码，用户登录密码先进行sha1加密（小写） 后再进行md5加密（小写）。
             *   2) 按A~z排序，串联成字符串，先进行sha1加密(小写)，再进行md5加密(小写)，得到签名
             */
            TLinx2Util.handleSign(postmap, pass);
            log.debug("安康逸华农商银行下载对账文件地址: {},参数: {}", getFileUrl, postmap);
            try {
                String res ;
                /**
                 * 2 请求、响应
                 */
                res = TLinx2Util.handlePost(postmap, getFileUrl);
                log.debug("请求结果：" + res);
                com.alibaba.fastjson.JSONObject respObject = com.alibaba.fastjson.JSONObject.parseObject(res);
                log.debug("====响应错误码：" + respObject.get("errcode"));
                log.debug("====响应错误提示：" + respObject.get("msg"));
                if (!res.isEmpty()) {
                    try {
                        final String downloadFilePath = Config.wechatConfig.getString("mendRecordPath") + File.separator + filiale + File.separator + billdate;
                        /**
                         * 3 保存到文本文件中
                         */
                        File file = new File(downloadFilePath);
                        if (!file.exists() && !file.isDirectory()) {
                            file.mkdirs();
                        }
                        String fileExt = ".txt";
                        String fileName = "bill_" + billdate;
                        File tmpFile = new File(downloadFilePath, fileName + fileExt);
                        //如果对账文件已经存在，则保留，并更名为fileName+当前时间戳+".txt.bak"
                        if (tmpFile.exists()) {
                            Files.move(tmpFile, new File(downloadFilePath, fileName + "_" + System.currentTimeMillis() / 1000 + fileExt + ".bak"));
                        }
                        Files.write(res, tmpFile, Charset.defaultCharset());

                        log.info("下载成功,文件路径为：{}",downloadFilePath);
                        result.put("status", "success");
                        result.put("respMsg", "下载对账文件成功");
                        result.put("path", downloadFilePath);

                    } catch (Exception e){
                        result.put("status", "fail");
                        result.put("respMsg", e);
                        log.debug("安康逸华农商银行下载对账文件", e);
                    }
                } else {
                    result.put("status", "fail");
                    log.info("下载失败");
                }
            } catch (Exception e) {
                result.put("status", "fail");
                log.debug("安康逸华农商银行下载对账文件异常：" + e);
            }
        } catch (Exception e) {
            result.put("status", "fail");
            result.put("respMsg", e);
            log.debug("安康逸华农商银行下载对账文件", e);
        }
        return result;
    }

    public JSONObject queryPayList() {
        JSONObject result = new JSONObject();
        // 初始化参数 0现金，1刷卡（拍卡），2主扫，3被扫，4jsapi，5预授权，6H5。也可以传空字符串，表示获取所有支付方式
        String pmtType = "0,1,2,3,4,5,6";
        String timestamp = System.currentTimeMillis() / 1000 + "";    // 时间
        JSONObject wxConfig = Config.getConfig("yihua");
        try {
            // 固定参数
            TreeMap<String, String> postmap = new TreeMap<String, String>();//请求参数的map
            postmap.put("open_id", wxConfig.getString("OPEN_ID"));
            postmap.put("timestamp", timestamp);

            TreeMap<String, String> datamap = new TreeMap<String, String>();//data参数的map
            datamap.put("pmt_type", pmtType);
            String getPayListUrl =  wxConfig.getString("getPayListUrl");
            String openKey = wxConfig.getString("OPEN_KEY");

            /**
             * 1 data字段内容进行AES加密，再二进制转十六进制(bin2hex)
             */
            TLinx2Util.handleEncrypt(datamap, postmap, openKey);

            /**
             * 2 请求参数签名 按A~z排序，串联成字符串，先进行sha1加密(小写)，再进行md5加密(小写)，得到签名
             */
            TLinx2Util.handleSignKey(postmap,openKey);

            /**
             * 3 请求、响应
             */
            String rspStr = TLinx2Util.handlePost(postmap, getPayListUrl);
            System.out.println("====post响应字符串= " + rspStr);

            /**
             * 4 验签  有data节点时才验签
             */
            com.alibaba.fastjson.JSONObject respObject = com.alibaba.fastjson.JSONObject.parseObject(rspStr);

            System.out.println("====响应错误码：" + respObject.get("errcode"));
            System.out.println("====响应错误提示：" + respObject.get("msg"));

            Object dataStr = respObject.get("data");

            if (!rspStr.isEmpty() || (dataStr != null)) {
                if (TLinx2Util.verifySign(respObject, openKey)) {    // 验签成功

                    /**
                     * 5 AES解密，并hex2bin
                     */
                    String respData = TLinx2Util.unicodeToCn(TLinxAESCoder.decrypt(dataStr.toString(), openKey));
                    System.out.println("=================响应data内容= " + respData);
                } else {
                    System.out.println("==========验签失败==========");
                }
            } else {
                System.out.println("==========没有返回data数据==========");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}
