package com.aote.pay.icbc.changan;

import com.alibaba.fastjson.JSON;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.icbc.meitan.*;
import com.aote.util.CreateSignUtils;
import com.aote.util.PayUtil;
import com.aote.util.UnionMD5;
import com.aote.util.WxSign;
import com.aote.utils.SSLClient;
import com.aote.weixin.Config;
import com.google.gson.Gson;
import com.ruim.ifsp.signature.IfspSdkSecurityAtureUtil;
import com.ruim.ifsp.signature.cert.IfspSdkConstants;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

@Slf4j
@Component
public class JsApiChangAn implements PaySuper {
    @Autowired
    private LogicServer logicServer;
    

    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        String userfilesid = json.getString("userfilesid");
        String phone =  json.getString("phone");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            // 发起方时间戳(yyyymmddhhmmssfff年月日时分秒毫秒)
            String timestamp = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            // 商户订单号
            String out_trade_no = PayUtil.getOrderNoByNumber();
            log.debug("outTradeNo:" + out_trade_no);

            String key = wxConfig.getString("key");

            String appid = wxConfig.getString("appid");

            String mct_id = wxConfig.getString("mct_id");


            String out_user_id = phone;

            int order_amt = PayUtil.yuan2FenInt(money);
            // 订单描述
            String order_body = "燃气缴费";

            //收银台类型  WX: 微信H5收银台（微信浏览器收银台）H5:H5收银台（普通浏览器收银台）
            String cashier_type = "WX";

            String sub_openid = openid;

            String sub_appid = wxConfig.getString("appId");

            String third_pay_time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());


            String nonce_str = WxSign.getNonceStr();

            SortedMap<String, Object> map = new TreeMap<>();
            map.put("appid", appid);
            map.put("mct_id", mct_id);
            map.put("out_trade_no", out_trade_no);
            map.put("order_amt", order_amt);
            map.put("out_user_id", out_user_id);
            map.put("cashier_type", cashier_type);
            map.put("order_body", order_body);
            map.put("third_pay_time", third_pay_time);
            map.put("nonce_str", nonce_str);
            map.put("sub_openid", sub_openid);
            map.put("sub_appid", sub_appid);


            // 加密签名
            String signNew= CreateSignUtils.createSign(map,key,"UTF-8");
            map.put("sign",signNew);

            String payUrl = wxConfig.getString("payUrl");
            log.debug("长安银行下单地址: {},下单参数: {}", payUrl, new JSONObject(map));

            CloseableHttpClient httpclient = null;
            CloseableHttpResponse response = null;

            HttpPost postRequest = new HttpPost(payUrl);
            postRequest.setHeader("Content-Type", "text/xml;utf-8");
            // 发送请求下单
            postRequest.setEntity(new StringEntity(JSON.toJSONString(map), "UTF-8"));
            httpclient = HttpClients.createDefault();

             response = httpclient.execute(postRequest);
            int StatusCode = response.getStatusLine().getStatusCode();
            if (StatusCode != 200) {
                log.debug("长安银行服务平台连接错误，错误代码:" + StatusCode);
                result.put("code", StatusCode);
                result.put("error", "长安银行服务平台连接错误，错误代码:" + StatusCode);
                return result.toString();
            }
            HttpEntity entity = response.getEntity();
            String rs = EntityUtils.toString(entity, "UTF-8");
            log.debug("同步返回结果："+rs);
            JSONObject responseJson = new JSONObject(rs);
            log.debug("长安银行下单返回结果：" + responseJson);
            if ("SUCCESS".equals(responseJson.getString("code"))) {
                JSONObject saveOrder = new JSONObject();
                saveOrder.put("f_out_trade_no", out_trade_no);
                saveOrder.put("f_attach", attach);
                saveOrder.put("f_openid", openid);
                saveOrder.put("f_order_state", "已下单");
                saveOrder.put("f_order_type", "燃气收费");
                saveOrder.put("flag", "JsApiChangAn");
                saveOrder.put("f_trade_type", "JSAPI");
                saveOrder.put("f_filiale", filiale);
                saveOrder.put("f_total_fee", String.valueOf(PayUtil.yuan2FenInt(money)));
                saveOrder.put("f_userfiles_id", userfilesid);
                // 保存分公司id
                JSONObject clientConfig = Config.getClientConfig(filiale);
                saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                logicServer.run("savewxreturnxml", saveOrder);

                result.put("code", 200);
                result.put("msg", "SUCCESS");
                result.put("f_out_trade_no", out_trade_no);
                JSONObject payInfo= new JSONObject(responseJson.get("prepay_data").toString());
                result.put("appId", payInfo.getString("appId"));
                result.put("timeStamp", payInfo.getString("timeStamp"));
                result.put("signType", payInfo.getString("signType"));
                result.put("package", payInfo.getString("packAge"));
                result.put("nonceStr", payInfo.getString("nonceStr"));
                result.put("paySign", payInfo.getString("paySign"));
            }else {
                result.put("code", responseJson.get("sub_code"));
                result.put("error", "下单失败，失败原因:" + responseJson.get("sub_msg").toString());
            }
        } catch (Exception e) {
            log.debug("长安银行下单异常错误", e);
        }
        return result.toString();
    }

    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            String key = wxConfig.getString("key");
            String appid = wxConfig.getString("appid");
            String nonce_str = WxSign.getNonceStr();
            String mct_id = wxConfig.getString("mct_id");
            // 原始商户交易流水号
            String out_trade_no = jsonObject.getString("out_trade_no");
            Map<String,Object> map = new HashMap<>();
            map.put("appid", appid);
            map.put("mct_id", mct_id);
            map.put("out_trade_no", out_trade_no);
            map.put("nonce_str", nonce_str);

            // 加密签名
            String signNew= CreateSignUtils.createSign(map,key,"UTF-8");
            map.put("sign",signNew);

            String queryUrl = wxConfig.getString("queryUrl");
            log.debug("长安银行下单地址: {},下单参数: {}", queryUrl, new JSONObject(map));

            CloseableHttpClient httpclient = null;
            CloseableHttpResponse response = null;

            HttpPost postRequest = new HttpPost(queryUrl);
            postRequest.setHeader("Content-Type", "text/xml;utf-8");
            // 发送请求下单
            postRequest.setEntity(new StringEntity(JSON.toJSONString(map), "UTF-8"));
            httpclient = HttpClients.createDefault();

            response = httpclient.execute(postRequest);
            int StatusCode = response.getStatusLine().getStatusCode();
            if (StatusCode != 200) {
                log.debug("长安银行服务平台连接错误，错误代码:" + StatusCode);
                result.put("code", StatusCode);
                result.put("error", "长安银行服务平台连接错误，错误代码:" + StatusCode);
                return result.toString();
            }
            HttpEntity entity = response.getEntity();
            String rs = EntityUtils.toString(entity, "UTF-8");
            log.debug("同步返回结果："+rs);
            JSONObject responseJson = new JSONObject(rs);
            log.debug("长安银行下单返回结果：" + responseJson);
            if ("SUCCESS".equals(responseJson.getString("code"))) {
                // 0000-交易成功;0007/0005-待支付，0006-交易已关闭
                if ("02".equals(responseJson.getString("status"))) {
                    if ("".equals(responseJson.optString("third_end_time"))) {
                        result.put("result_code", "FAIL");
                        result.put("return_msg", "订单没有交易时间");
                    } else {
                        result.put("result_code", "SUCCESS");
                        result.put("trade_state", "SUCCESS");
                        // 订单号
                        result.put("transaction_id", responseJson.getString("order_id"));
                        // 交易日期
                        result.put("time_end", responseJson.optString("third_end_time"));
                        // 交易金额
                        result.put("total_fee",PayUtil.yuan2FenInt(String.valueOf(responseJson.get("pay_amt"))));
                    }
                } else {
                    result.put("result_code", "FAIL");
                    result.put("return_msg", responseJson.opt("sub_msg"));
                    log.debug("订单状态不等于已支付：" + responseJson.get("sub_code"));
                }
            } else {
                result.put("result_code", "FAIL");
                result.put("return_msg", responseJson.get("respCode"));
                log.debug("查询订单异常：" + responseJson.get("respMsg"));
            }
        } catch (Exception e) {
            result.put("trade_state", "FAIL");
            log.debug("长安银行查询订单异常：" + e);
        }
        return result.toString();
    }
}
