package com.aote.pay.boc.qianneng;

import cn.hutool.http.HttpUtil;
import com.af.plugins.DateTools;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.sql.SqlServer;
import com.aote.util.FileUtils;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.*;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Calendar;


@Slf4j
@Component
public class JsApiQianNengBoc implements PaySuper , RefundSuper {
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private SqlServer sqlServer;
    
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String newAttach = json.getJSONObject("attach").toString();
        JSONObject attach = json.getJSONObject("attach");
        JSONObject newAttachParam = new JSONObject();
        log.debug("下单attach=" + attach);
        if (attach.has("f_type")){
            if ("siteOtherFee".equals(attach.getString("f_type"))){
                newAttachParam.put("f_userfiles_id",attach.optString("f_userfiles_id", ""));
                newAttachParam.put("money",attach.optString("money", ""));
                newAttach = newAttachParam.toString();
            }
        }
        String filiale = json.getString("filiale");
        String userfilesid = json.optString("userfilesid","");
        String orderType = json.optString("orderType","燃气收费");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            // service 微信公众号  wxJsPay
            String service = "wxJsPay";
            String mchNo = wxConfig.getString("mchNo");
            String appid = wxConfig.getString("appId");
            // 商户订单号  系统生成  这个是30位的要截取一下
            String outTradeNo = PayUtil.getOrderNoByNumber();
            // 固定值，公众号要传  wechat_jsapi
            String tradeType = "wechat_jsapi";
            // 商品描述
            String body = orderType+"-"+userfilesid;
            // 商品详情
            String detail = orderType;
            // 这个订单金额元转为分
            String totalAmount = String.valueOf(PayUtil.yuan2FenInt(money));
            String notifyUrl = wxConfig.getString("wechatNotify");
            JSONObject bodyParam = new JSONObject();
            bodyParam.put("service",service);
            bodyParam.put("merchantMsg",mchNo);
            bodyParam.put("storeNo","");
            bodyParam.put("outTradeNo",outTradeNo);
            bodyParam.put("tradeType",tradeType);
            bodyParam.put("body",body);
            bodyParam.put("f_attach",newAttach);
            bodyParam.put("currency","");
            bodyParam.put("buyerId",openid);
            bodyParam.put("deviceInfo","");
            bodyParam.put("clientIp","");
            bodyParam.put("limitCredit","");
            bodyParam.put("startTime","");
            bodyParam.put("expireTime","");
            bodyParam.put("fixBuyer","");
            bodyParam.put("buyerName","");
            bodyParam.put("buyerMobile","");
            bodyParam.put("buyerCertType","");
            bodyParam.put("buyerCertNo","");
            bodyParam.put("detail",detail);
            bodyParam.put("pay_source","微信");
            bodyParam.put("totalAmount",totalAmount);
            bodyParam.put("notifyUrl",notifyUrl);
            bodyParam.put("wxAppid",appid);
            // 调用银行的接口（银行对接之后接口传参）
            JSONObject dataParam = new JSONObject();
            dataParam.put("data",bodyParam);
            String PayUrl = wxConfig.getString("PayUrl");
            log.debug("潜能中行下单地址: {},下单bogy参数: {}", PayUrl, dataParam);

            String res ;
            try {
                res = HttpUtil.post(PayUrl,dataParam.toString());
                log.debug("请求结果：" + res);
                JSONObject responseJson = new JSONObject(res);
                // 业务代码
                if (responseJson.getInt("status")==200) {
                    JSONObject saveOrder = new JSONObject();
                    saveOrder.put("f_out_trade_no", outTradeNo);
                    saveOrder.put("f_attach", attach);
                    saveOrder.put("f_openid", openid);
                    saveOrder.put("f_order_state", "已下单");
                    saveOrder.put("f_order_type", orderType);
                    saveOrder.put("flag", "JsApiQianNengBoc");
                    saveOrder.put("f_trade_type", "JSAPI");
                    JSONObject resultBody = responseJson.getJSONObject("body");
                    // 平台订单号
                    saveOrder.put("tradeNo",resultBody.getString("tradeNo"));
                    saveOrder.put("f_filiale", filiale);
                    saveOrder.put("f_total_fee", String.valueOf(PayUtil.yuan2FenInt(money)));
                    saveOrder.put("f_userfiles_id", userfilesid);
                    // 保存分公司id
                    JSONObject clientConfig = Config.getClientConfig(filiale);
                    saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                    logicServer.run("savewxreturnxml", saveOrder);

                    result.put("code", 200);
                    result.put("msg", "SUCCESS");
                    result.put("out_trade_no", outTradeNo);
                    // 平台订单号
                    result.put("tradeNo",resultBody.getString("tradeNo"));
                    // 业务结果详情
                    result.put("Message",resultBody.getString("Message"));
                    // 付款凭证
                    result.put("prepayId",resultBody.getString("prepayId"));
                    // 付款信息
                    result.put("payInfo",resultBody.getString("payInfo"));
                }else {
                    result.put("code", responseJson.getInt("status"));
                    result.put("error", "下单失败，失败原因:" + responseJson.get("msg").toString());
                }
            } catch (Exception e) {
                log.debug("请求响应错误");
                result.put("result_msg", "请求响应错误");
                result.put("err_msg", e.getMessage());
                throw new RuntimeException("下单请求潜能中行未正常响应");
            }
        }catch (Exception e) {
            log.debug("潜能中行下单异常错误", e);
        }
        return result.toString();
    }

    public String microPay(JSONObject json) {
        log.debug("潜能中行收到付款码下单支付请求:{}", json);
        String money = json.getString("money");
        String filiale = json.getString("filiale");
        String userFilesId = json.optString("f_userfiles_id", "");
        String newAttach = json.getJSONObject("attach").toString();
        JSONObject attach = json.getJSONObject("attach");
        JSONObject newAttachParam = new JSONObject();
        log.debug("下单attach=" + attach);
        if (attach.has("f_type")){
            if ("siteOtherFee".equals(attach.getString("f_type"))){
                newAttachParam.put("f_userfiles_id",attach.optString("f_userfiles_id", ""));
                newAttachParam.put("money",attach.optString("money", ""));
                newAttach = newAttachParam.toString();
            }
        }
        String body = json.optString("body", "燃气-天然气");
        // 扫码支付授权码
        String authCode =  json.getString("auth_code");
        // 什么钱？
        String orderType = json.optString("orderType","燃气收费");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject clientConfig = Config.getClientConfig(filiale);
        JSONObject result = new JSONObject();
        // 商户订单号  系统生成  这个是30位的要截取一下
        String outTradeNo = PayUtil.getOrderNoByNumber();
        try {
            String service = "microPay";
            String mchNo = wxConfig.getString("mchNo");
            // 商户订单号  系统生成  这个是30位的要截取一下
            // 这个订单金额元转为分
            String totalAmount = String.valueOf(PayUtil.yuan2FenInt(money));
            JSONObject bodyParam = new JSONObject();
            bodyParam.put("service",service);
            bodyParam.put("merchantMsg",mchNo);
            bodyParam.put("deviceInfo",json.optString("deviceInfo", ""));
            bodyParam.put("body",body);
            bodyParam.put("detail",body);
            bodyParam.put("f_attach",newAttach);
            bodyParam.put("totalAmount",totalAmount);
            bodyParam.put("authCode",authCode);
            bodyParam.put("f_userfiles_id",userFilesId);
            bodyParam.put("f_filiale",filiale);
            bodyParam.put("orderType",orderType);
            bodyParam.put("outTradeNo",outTradeNo);
            bodyParam.put("pay_source","微信");
            bodyParam.put("f_trade_type","MICROPAY");
            bodyParam.put("f_orgid", clientConfig.get("orgStr"));
            JSONObject dataParam = new JSONObject();
            dataParam.put("data",bodyParam);
            // 扫码下单接口
            String microPayUrl = wxConfig.getString("microPayUrl");
            log.debug("潜能中行查询扫码下单接口: {},下单参数: {}", microPayUrl, dataParam);
            String res ;
            res =  HttpUtil.post(microPayUrl,dataParam.toString());
            log.debug("请求结果：" + res);
            JSONObject responseJson = new JSONObject(res);
            if (responseJson.getInt("status") == 200) {
                // 支付成功了
                result.put("result_code", "SUCCESS");
                result.put("result_msg", "支付结果未知");
                result.put("trade_state", "SUCCESS");
                JSONObject resultBody = responseJson.getJSONObject("body");
                result.put("transaction_id", resultBody.getString("transactionId"));
                // 交易时间
                result.put("time_end", resultBody.getString("tradeTime"));
                result.put("out_trade_no", resultBody.getString("outTradeNo"));
           } else {
                result.put("result_code", "FAIL");
                result.put("result_msg",  "支付确认失败");
                result.put("trade_state", "FAIL");
            }
        } catch (Exception e) {
            log.debug("付款码下单异常", e);
        }
        return result.toString();
    }
    public String codePay(JSONObject json) {
        log.debug("潜能中行收到二维码下单支付请求:{}", json);
        String money = json.getString("money");
        String filiale = json.getString("filiale");
        String userFilesId = json.optString("f_userfiles_id", "");
        String newAttach = json.getJSONObject("attach").toString();
        JSONObject attach = json.getJSONObject("attach");
        JSONObject newAttachParam = new JSONObject();
        log.debug("下单attach=" + attach);
        if (attach.has("f_type")){
            if ("siteOtherFee".equals(attach.getString("f_type"))){
                newAttachParam.put("f_userfiles_id",attach.optString("f_userfiles_id", ""));
                newAttachParam.put("money",attach.optString("money", ""));
                newAttach = newAttachParam.toString();
            }
        }
        String body = json.optString("body", "燃气-天然气");
        String orderType = json.optString("orderType","燃气收费");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject clientConfig = Config.getClientConfig(filiale);
        JSONObject result = new JSONObject();
        // 商户订单号  系统生成  这个是30位的要截取一下
        String outTradeNo = PayUtil.getOrderNoByNumber();
        try {
            String service = "nativePay";
            String mchNo = wxConfig.getString("mchNo");
            // 这个订单金额元转为分
            String totalAmount = String.valueOf(PayUtil.yuan2FenInt(money));
            String notifyUrl = wxConfig.getString("codeNotify");
            JSONObject bodyParam = new JSONObject();
            bodyParam.put("service",service);
            bodyParam.put("merchantMsg",mchNo);
            bodyParam.put("body",body);
            bodyParam.put("detail",body);
            bodyParam.put("f_attach",newAttach);
            bodyParam.put("totalAmount",totalAmount);
            bodyParam.put("tradeType","wechat_native");
            bodyParam.put("notifyUrl",notifyUrl);
            bodyParam.put("f_userfiles_id",userFilesId);
            bodyParam.put("f_filiale",filiale);
            bodyParam.put("orderType",orderType);
            bodyParam.put("outTradeNo",outTradeNo);
            bodyParam.put("pay_source","微信");
            bodyParam.put("f_trade_type","NATIVE");
            bodyParam.put("f_orgid", clientConfig.get("orgStr"));
            JSONObject dataParam = new JSONObject();
            dataParam.put("data",bodyParam);
            // 扫码下单接口
            String microPayUrl = wxConfig.getString("microPayUrl");

            log.debug("潜能中行二维码下单接口: {},下单参数: {}", microPayUrl, dataParam);
            String res ;
            res =  HttpUtil.post(microPayUrl,dataParam.toString());
            log.debug("请求结果：" + res);
            JSONObject responseJson = new JSONObject(res);
            if (responseJson.getInt("status") == 200) {
                // 支付成功了
                result.put("code", 200);
                result.put("result_msg", "二维码下单成功");
                JSONObject resultBody = responseJson.getJSONObject("body");
                result.put("url", resultBody.getString("url"));
            } else {
                result.put("code", 500);
                result.put("result_msg",  "二维码下单失败");
            }
        } catch (Exception e) {
            log.debug("二维码下单异常", e);
        }
        return result.toString();
    }
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));

            // service queryOrder
            String service = "queryOrder";
            String mchNo = wxConfig.getString("mchNo");
            // 商户订单号
            String outTradeNo = jsonObject.getString("out_trade_no");
            // 平台订单号 tradeNo / 第三方订单号 transactionId

            JSONObject bodyParam = new JSONObject();
            bodyParam.put("service",service);
            bodyParam.put("merchantMsg",mchNo);
            bodyParam.put("outTradeNo",outTradeNo);
            bodyParam.put("tradeNo","");
            JSONObject dataParam = new JSONObject();
            dataParam.put("data",bodyParam);
            // 查询订单结果接口
            String QueryUrl = wxConfig.getString("QueryUrl");

            log.debug("潜能中行查询地址: {},查询dataParam参数: {}", QueryUrl, dataParam);
            String res ;

            res =  HttpUtil.post(QueryUrl,dataParam.toString());
            log.debug("请求结果：" + res);
            JSONObject responseJson = new JSONObject(res);
            if (responseJson.getInt("status") == 200) {
                // 支付成功了
                result.put("result_code", "SUCCESS");
                result.put("trade_state", "SUCCESS");
                JSONObject bodyData = responseJson.getJSONObject("body");
                result.put("transaction_id", bodyData.getString("transactionId"));
                // 交易时间
                result.put("time_end", bodyData.getString("tradeTime"));
                result.put("total_fee", bodyData.opt("totalAmount"));
//                //付款银行账号
//                result.put("",responseJson.getString("toAcctNo"));
                // 付款银行名称
                result.put("bank_type",bodyData.getString("toAcctName"));
            } else {
                result.put("result_code", "FAIL");
                result.put("result_msg",  responseJson.getString("msg"));
            }
            } catch (Exception e) {
                log.debug("潜能中行查询订单异常", e);
                result.put("result_code", "FAIL");
                result.put("trade_state", "FAIL");
                result.put("result_msg", e.getMessage());
            }
            log.debug("查询订单返回: {}", result.toString());
            return result.toString();
    }

    @Override
    public String refund(JSONObject json) {
        String filiale = json.getString("f_filiale");
        Integer id = json.getInt("id");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            JSONObject refundParam = new JSONObject();
            String service = "refundOrder";
            // 商户号
            String mchNo = wxConfig.getString("mchNo");
            // 商户订单号，商户端保证唯一
            String outTradeNo = json.getString("out_trade_no");
            // 平台订单编号 f_transid
            String transactionId = json.optString("transaction_id","");
            // 退款金额金额
            String refundAmount = json.getString("f_total_fee");
            String refundReason = "退款";
            String opUserId = "微信公众号";
            // 下单地址
            refundParam.put("service",service);
            refundParam.put("transactionId",transactionId);
            refundParam.put("merchantMsg",mchNo);
            refundParam.put("outTradeNo",outTradeNo);
            refundParam.put("tradeNo","");
            refundParam.put("outRefundNo",outTradeNo);
            refundParam.put("refundAmount",refundAmount);
            refundParam.put("refundReason",refundReason);
            refundParam.put("opUserId",opUserId);
            JSONObject dataParam = new JSONObject();
            dataParam.put("data",dataParam);
            String refundUrl = wxConfig.getString("refundUrl");
            log.debug("潜能中行退款地址: {},退款参数: {}", refundUrl, refundParam);
            try {
                String res ;
                res =  HttpUtil.post(refundUrl,refundParam.toString());
                log.debug("请求结果：" + res);
                JSONObject responseJson = new JSONObject(res);

                log.debug("潜能中行退款返回数据: {}", responseJson);
                if (responseJson.getInt("status") == 500) {
                    result.put("result_msg", "退款失败");
                    result.put("trade_state", "FAIL");
                } else  {
                    JSONObject saveOrder = new JSONObject();
                    result.put("result_msg", "退款中");
                    result.put("trade_state", "SUCCESS");
                    this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='退款中' where id = '" + id + "'");
                }
            } catch (Exception var9) {
                var9.printStackTrace();
            }
        } catch (Exception e) {
            log.debug("潜能中行退款异常错误", e);
        }
        return result.toString();
    }


    /**
     * 查询订单是否退款成功
     *
     * @param value
     * @return 订单退款结果
     */
    @Override
    public String refundOrderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询退款订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            String service = "refundQuery";
            String mchNo = wxConfig.getString("mchNo");
            // 商户订单号
            String outTradeNo = jsonObject.getString("out_trade_no");
            Integer id = jsonObject.getInt("id");
            JSONObject refundParam = new JSONObject();
            refundParam.put("service",service);
            refundParam.put("merchantMsg",mchNo);
            refundParam.put("refundNo","");
            refundParam.put("outTradeNo",outTradeNo);
            refundParam.put("outRefundNo",outTradeNo);
            JSONObject dataParam = new JSONObject();
            dataParam.put("data",refundParam);
            // 下单地址
            String queryUrl = wxConfig.getString("queryRefundUrl");
            log.debug("潜能中行退款结果查询地址: {},查询参数: {}", queryUrl, dataParam);

            try {
                String res ;
                res = HttpUtil.post(queryUrl,dataParam.toString());
                log.debug("请求结果：" + res);
                JSONObject responseJson = new JSONObject(res);
                log.debug("潜能中行退款结果查询返回信息: {}", responseJson);
                if (responseJson.getInt("status") == 200) {
                    JSONObject resultData = responseJson.getJSONObject("body");
                    this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已退款' where id = '" + id + "'");
                    this.sqlServer.runSQL("update t_bank_payment set f_state ='无效' where f_trade_number = '"+ jsonObject.getString("out_trade_no") +"'");
                    result.put("result_msg", "退款成功");
                    result.put("trade_state", "FAIL");
                    // 订单号
                    result.put("out_trade_no", resultData.getString("outRefundNo"));
                    // 交易日期
                    result.put("time_end", resultData.getString("refundTime"));
                    log.debug(result.toString());
                } else if (responseJson.getInt("status") == 502) {
                    result.put("return_msg", "退款处理中");
                    result.put("trade_state", "FAIL");
                    log.debug("订单状态不等于已支付：" + responseJson.getString("status"));
                } else if (responseJson.getInt("status") == 501) {
                    result.put("return_msg", responseJson.getString("msg"));
                    result.put("trade_state", "FAIL");
                    log.debug("查询失败", responseJson.getString("msg"));
                } else {
                    this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已支付' where id = '" + id + "'");
                    result.put("trade_state", "FAIL");
                    result.put("return_msg", "退款失败");
                }
            } catch (Exception var9) {
                this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已支付' where id = '" + id + "'");
                log.error("操作失败：原因" + var9.getMessage());
                result.put("return_msg", "系统异常");
                var9.printStackTrace();
            }
        } catch (Exception e) {
            result.put("return_msg", "查询失败");
            log.debug("中行查询订单异常：" + e);
        }
        return result.toString();
    }

    @Override
    public JSONObject getRecordFile(JSONObject json) {
        String filiale = json.getString("f_filiale");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            // 下载对账文件地址
            String getFileUrl =  wxConfig.getString("getFileUrl");
            String mchNo = wxConfig.getString("mchNo");
            // 默认是查前一天
            Calendar cal = Calendar.getInstance();
            cal.add(Calendar.DATE,-1);
            String billdate = new SimpleDateFormat( "yyyy-MM-dd").format(cal.getTime());
            JSONObject getFileParam = new JSONObject();
            getFileParam.put("service","reconDownload");
            getFileParam.put("merchantMsg",mchNo);
            getFileParam.put("billdate",billdate);
            getFileParam.put("settle_type",1);
            JSONObject dataParam = new JSONObject();
            dataParam.put("data",getFileParam);
            log.debug("潜能中行下载对账文件地址: {},参数: {}", getFileUrl, dataParam);
            try {
                String res ;
                res =  HttpUtil.post(getFileUrl,dataParam.toString());
                log.debug("请求结果：" + res);
                JSONObject responseJson = new JSONObject(res);
                if (responseJson.getInt("status") == 200) {
                    JSONObject resultData = responseJson.getJSONObject("body");
                    String downloadUrl = resultData.getString("downFileName");
                    try {
                        final String downloadFilePath = Config.wechatConfig.getString("mendRecordPath") + File.separator + filiale + File.separator + billdate + ".csv";
                        long size = HttpUtil.downloadFile(downloadUrl,downloadFilePath);
                        log.info("下载成功,文件大小为：{},文件路径为：{}",size,downloadFilePath);
                        result.put("status", "success");
                        result.put("respMsg", "下载对账文件成功");
                        result.put("path", downloadFilePath);
                        result.put("size", size);
                    } catch (Exception e){
                        result.put("status", "fail");
                        result.put("respMsg", e);
                        log.debug("潜能中行下载对账文件", e);
                    }
                } else {
                    result.put("status", "fail");
                    log.info("下载失败");
                }
            } catch (Exception e) {
                result.put("status", "fail");
                log.debug("潜能中行下载对账文件异常：" + e);
            }
        } catch (Exception e) {
            result.put("status", "fail");
            result.put("respMsg", e);
            log.debug("潜能中行下载对账文件", e);
        }
        return result;
    }
}
