package com.aote.entity;

import java.util.List;

public class PayBodyEntity {
    //消息ID
    String msgId;
    //报文请求时间，格式yyyy-MM-ddHH:mm:ss
    String requestTimestamp;
    //商户订单号
    String merOrderId;
    //请求系统预留字段
    String srcReserve;
    //商户号
    String mid;
    //终端号
    String tid;
    //业务类型
    String instMid;
    //分账标记
    String divisionFlag;
    //平台商户分账金额
    String platformAmount;
    //商品信息
    List<GoodsItem> goods;
    //商户附加数据
    String attachedData;
    //账单描述
    String orderDesc;
    //商品标记
    String goodsTag;
    //订单原始金额
    String originalAmount;
    //支付总金额
    String totalAmount;
    //支付结果通知地址
    String notifyUrl;
    //网页跳转地址
    String returnUrl;
    //系统ID
    String systemId;
    //实名认证姓名
    String name;
    //实名认证手机号
    String mobile;
    //实名认证证件类型
    String certType;
    //实名认证证件号
    String certNo;
    //是否需要实名认证
    String fixBuyer;
    //是否需要限制信用卡支付
    String limitCreditCard;
    //担保交易标识
    String secureTransaction;

    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getRequestTimestamp() {
        return requestTimestamp;
    }

    public void setRequestTimestamp(String requestTimestamp) {
        this.requestTimestamp = requestTimestamp;
    }

    public String getMerOrderId() {
        return merOrderId;
    }

    public void setMerOrderId(String merOrderId) {
        this.merOrderId = merOrderId;
    }

    public String getSrcReserve() {
        return srcReserve;
    }

    public void setSrcReserve(String srcReserve) {
        this.srcReserve = srcReserve;
    }

    public String getMid() {
        return mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getInstMid() {
        return instMid;
    }

    public void setInstMid(String instMid) {
        this.instMid = instMid;
    }

    public String getDivisionFlag() {
        return divisionFlag;
    }

    public void setDivisionFlag(String divisionFlag) {
        this.divisionFlag = divisionFlag;
    }

    public String getPlatformAmount() {
        return platformAmount;
    }

    public void setPlatformAmount(String platformAmount) {
        this.platformAmount = platformAmount;
    }

    public List<GoodsItem> getGoods() {
        return goods;
    }

    public void setGoods(List<GoodsItem> goods) {
        this.goods = goods;
    }

    public String getAttachedData() {
        return attachedData;
    }

    public void setAttachedData(String attachedData) {
        this.attachedData = attachedData;
    }

    public String getOrderDesc() {
        return orderDesc;
    }

    public void setOrderDesc(String orderDesc) {
        this.orderDesc = orderDesc;
    }

    public String getGoodsTag() {
        return goodsTag;
    }

    public void setGoodsTag(String goodsTag) {
        this.goodsTag = goodsTag;
    }

    public String getOriginalAmount() {
        return originalAmount;
    }

    public void setOriginalAmount(String originalAmount) {
        this.originalAmount = originalAmount;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getCertType() {
        return certType;
    }

    public void setCertType(String certType) {
        this.certType = certType;
    }

    public String getCertNo() {
        return certNo;
    }

    public void setCertNo(String certNo) {
        this.certNo = certNo;
    }

    public String getFixBuyer() {
        return fixBuyer;
    }

    public void setFixBuyer(String fixBuyer) {
        this.fixBuyer = fixBuyer;
    }

    public String getLimitCreditCard() {
        return limitCreditCard;
    }

    public void setLimitCreditCard(String limitCreditCard) {
        this.limitCreditCard = limitCreditCard;
    }

    public String getSecureTransaction() {
        return secureTransaction;
    }

    public void setSecureTransaction(String secureTransaction) {
        this.secureTransaction = secureTransaction;
    }

    String toJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.msgId != null) sb.append("\"msgId\":\"" + this.msgId + "\",");
        if (this.requestTimestamp != null) sb.append("\"requestTimestamp\":\"" + this.requestTimestamp + "\",");
        if (this.merOrderId != null) sb.append("\"merOrderId\":\"" + this.merOrderId + "\",");
        if (this.srcReserve != null) sb.append("\"srcReserve\":\"" + this.srcReserve + "\",");
        if (this.mid != null) sb.append("\"mid\":\"" + this.mid + "\",");
        if (this.tid != null) sb.append("\"tid\":\"" + this.tid + "\",");
        if (this.instMid != null) sb.append("\"instMid\":\"" + this.instMid + "\",");
        if (this.divisionFlag != null) sb.append("\"divisionFlag\":\"" + this.divisionFlag + "\",");
        if (this.platformAmount != null) sb.append("\"platformAmount\":\"" + this.platformAmount + "\",");
        if (this.goods != null && this.goods.size() > 0) {
            sb.append("\"goods\":[");
            for (int i = 0; i < goods.size(); i++) {
                sb.append(goods.get(i));
                sb.append(",");
            }
            if (sb.charAt(sb.length() - 1) == ',')
                sb.deleteCharAt(sb.length() - 1);
            sb.append("],");
        }
        if (this.totalAmount != null) sb.append("\"totalAmount\":\"" + this.totalAmount + "\",");
        if (this.orderDesc != null) sb.append("\"orderDesc\":\"" + this.orderDesc + "\",");
        if (this.originalAmount != null) sb.append("\"originalAmount\":\"" + this.originalAmount + "\",");
        if (this.goodsTag != null) sb.append("\"goodsTag\":\"" + this.goodsTag + "\",");
        if (this.attachedData != null) sb.append("\"attachedData\":\"" + this.attachedData + "\",");
        if (this.notifyUrl != null) sb.append("\"notifyUrl\":\"" + this.notifyUrl + "\",");
        if (this.returnUrl != null) sb.append("\"returnUrl\":\"" + this.returnUrl + "\",");
        if (this.systemId != null) sb.append("\"systemId\":\"" + this.systemId + "\",");
        if (this.name != null) sb.append("\"name\":\"" + this.name + "\",");
        if (this.certType != null) sb.append("\"certType\":\"" + this.certType + "\",");
        if (this.certNo != null) sb.append("\"certNo\":\"" + this.certNo + "\",");
        if (this.fixBuyer != null) sb.append("\"fixBuyer\":\"" + this.fixBuyer + "\",");
        if (this.secureTransaction != null) sb.append("\"secureTransaction\":\"" + this.secureTransaction + "\",");
        if (this.mobile != null) sb.append("\"mobile\":\"" + this.mobile + "\",");
        if (this.limitCreditCard != null) sb.append("\"limitCreditCard\":\"" + this.limitCreditCard + "\",");
        if (sb.charAt(sb.length() - 1) == ',')
            sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return this.toJson();
    }

    static class GoodsItem {
        //商品ID
        String goodsId;
        //商品名称
        String goodsName;
        //商品数量
        String quantity;
        //商品单价（分）
        String price;
        //商品分类
        String goodsCategory;
        //商品说明
        String body;
        //子商户号
        String subMerchantId;
        //子商户商品总额
        int subOrderAmount;

        String toJson() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            if (this.goodsId != null) sb.append("\"goodsId\":\"" + this.goodsId + "\",");
            if (this.goodsName != null) sb.append("\"goodsName\":\"" + this.goodsName + "\",");
            if (this.quantity != null) sb.append("\"quantity\":\"" + this.quantity + "\",");
            if (this.price != null) sb.append("\"price\":\"" + this.price + "\",");
            if (this.goodsCategory != null) sb.append("\"goodsCategory\":\"" + this.goodsCategory + "\",");
            if (this.body != null) sb.append("\"body\":\"" + this.body + "\",");
            if (this.subMerchantId != null) sb.append("\"subMerchantId\":\"" + this.subMerchantId + "\",");
            if (this.subOrderAmount != 0) sb.append("\"subOrderAmount\":\"" + this.subOrderAmount + "\",");
            if (sb.charAt(sb.length() - 1) == ',')
                sb.deleteCharAt(sb.length() - 1);
            sb.append("}");
            return sb.toString();
        }

        public String toString() {
            return this.toJson();
        }
    }

}
