/**查询用户气表信息**/
SELECT * FROM (
SELECT
    uf.f_userfiles_id,
    uf.f_user_id,
    uf.f_user_type,
    uf.f_userinfo_id,
    uf.f_meternumber,
    uf.f_civill_id,
    f_meter_classify,
    f_balance_amount,
    f_balance_gas,
    f_meter_base,
    f_card_id,
    uf.f_times,
    uf.f_meteread_maxid,
    f_collection_type, -- 缴费方式
    f_total_gas, -- 表累购气量
    uf.f_card_password, -- 卡密码
    gb.f_alias,  --别名
    gb.f_police_gas, -- 报警气量
    gb.f_topup_ceil, --充值上限
    gb.f_overdr_lines, -- 透支额度
    gb.f_meter_brand, -- 表品牌
    gb.f_calculation, --表端计费/系统计费
    sp.f_price_name,
    sp.f_price_id,
    f_table_state,
    {entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(m.f_jval, 0) f_jval,
    m.f_last_insertdate,
    uf.f_hand_date,
    sp.id f_stairid
FROM
    t_userfiles uf LEFT JOIN t_gasbrand gb on uf.f_gasbrand_id = gb.id
                   LEFT JOIN (
        SELECT
            f_price_name,f_price_id,id
        FROM
            t_stairprice
        WHERE
             getdate() >= f_perform_date AND getdate() <= f_end_date AND f_state = '有效'
    ) sp ON sp.f_price_id = uf.f_price_id
    LEFT JOIN t_meteread m on m.id = uf.f_meteread_maxid
              ) t
WHERE
    {condition} AND f_table_state = '正常'
ORDER BY
    f_user_id
