-- 公共SQL：查询待换表补气的表具信息（银光系统与抄表系统对接用)
-- 必选参数
-- f_meter_brand：气表品牌名称，如宇迪NB物联网表，伦力NB物联网表等

SELECT h.id                        id,
       u.id                        f_user_id,
       u.f_userid                  f_userinfo_id,
       h.f_cmnewmeternumber        f_newmeternumber,
       ui.f_usertype,
       u.f_display_type,
       u.f_meteramountnums,
       u.f_metergasnums,
       isnull(ui.f_stairmonths, 1) f_stairmonths,
       ui.f_stair1amount,
       ui.f_stair1price,
       ui.f_stair2amount,
       ui.f_stair2price,
       ui.f_stair3amount,
       ui.f_stair3price,
       ui.f_address                f_address,
       h.f_metergasnums            f_table_base,
       h.f_cmoperator              f_operator,
       ui.f_phone                  f_phone,
       ui.f_username               f_username,
       u.f_times,
       isnull(h.f_cmaddgas, 0)     f_pregas,
       isnull(h.f_prejine, 0)      f_preamount
FROM t_changmeter h
         LEFT JOIN t_userfiles u ON u.f_userid = h.f_userid and u.f_meternumber = h.f_cmnewmeternumber
         LEFT JOIN t_userinfo ui ON ui.f_userid = u.f_userinfoid
WHERE u.f_aliasname = '{f_meter_brand}'
  AND u.f_userstate = '正常'
  AND u.f_sendsuccess = '成功'
  AND (h.f_isSupplyGas <> '成功' OR h.f_isSupplyGas IS NULL)
  AND (isnull(h.f_cmaddgas, 0) > 0 or isnull(h.f_prejine, 0) > 0)
