SELECT ts.id,
       tf.f_user_id,
       ts.f_meternumber,
       ts.f_collection,
       ts.f_userinfo_id,
       ts.f_times
FROM t_sellinggas ts
         LEFT JOIN t_userfiles tf ON ts.f_user_id = tf.f_user_id
         LEFT JOIN t_gasbrand tg ON tf.f_gasbrand_id = tg.id
         LEFT JOIN t_stairprice st ON st.f_price_id = tf.f_price_id and tf.f_orgid = st.f_orgid
WHERE ts.f_charge_state = '有效'
  AND (ts.f_sendsuccess <> '成功' OR ts.f_sendsuccess IS NULL)
  AND tg.f_alias = '{f_meter_brand}'
  AND tf.f_sendsuccess = '成功'
  AND ts.f_charge_type = '物联网收费'
  AND st.f_state = '有效'
  AND getdate() >= st.f_perform_date
  AND getdate() <= st.f_end_date
ORDER BY ts.f_times
