-- 公共SQL：查询待开户的表具信息
-- 必选参数
-- f_meter_brand：气表品牌名称，如宇迪NB物联网表，伦力NB物联网表等

SELECT
       u.f_userinfo_id,
       u.f_user_id,
       b.f_alias,
       u.version,
       u.f_orgid,
       u.f_depid,
       i.f_createfile_date CmdSendTime,
       u.f_meternumber f_meternumber,
       u.f_filialeid,
       s.f_price_name,
       s.f_price_id
FROM t_userfiles u
         LEFT JOIN t_userinfo i ON u.f_userinfo_id = i.f_userinfo_id
         LEFT JOIN t_gasbrand b ON u.f_gasbrand_id = b.id
         LEFT JOIN t_stairprice s ON s.f_price_id = u.f_price_id and u.f_orgid = s.f_orgid
WHERE (
            u.f_sendsuccess <> '成功'
        OR u.f_sendsuccess IS NULL
    )
  AND b.f_alias = '{f_meter_brand}'
  AND u.f_table_state != '停用'
  AND u.f_table_state != '换表'
  AND i.f_user_state = '正常'
  AND s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  and getdate() <= s.f_end_date
ORDER BY i.f_createfile_date
