/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.aote.module.ModuleMapper;
import com.aote.redis.RedisUtil;
import com.aote.sql.SqlServer;
import com.aote.webmeter.tools.WebMeterInfo;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class RedisInitDataTools {
    private static final Logger LOGGER = Logger.getLogger(RedisInitDataTools.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    public SessionFactory sessionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public void redisInitDataTools() throws Exception {
        LOGGER.debug((Object)"*****\u52a0\u8f7d\u7269\u8054\u7f51\u8868\u670d\u52a1\u7ed3\u7b97\u6240\u9700Redis\u6570\u636e*****");
        Map map = ModuleMapper.getMap();
        for (String moduleName : map.keySet()) {
            WebMeterInfo.setModuleName(moduleName);
            if (!WebMeterInfo.has("meterBrandName").booleanValue()) continue;
            String alias = WebMeterInfo.getString("meterBrandName");
            if (WebMeterInfo.has("isRedis").booleanValue()) {
                Session session = this.sessionFactory.openSession();
                TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)session);
                try {
                    JSONArray userfilesArray;
                    LOGGER.debug((Object)("*****\u6a21\u5757\u3010" + moduleName + "\u3011\u52a0\u8f7dRedis\u6570\u636e*****"));
                    int pageIndex = 1;
                    JSONObject params = new JSONObject();
                    params.put("data", (Object)new JSONObject().put("f_meter_brand", (Object)alias));
                    while ((userfilesArray = this.sqlServer.query("redisGetMeterInfo", pageIndex, 500, params.toString())).length() != 0) {
                        LOGGER.debug((Object)("*****\u52a0\u8f7d\u8868\u6863\u6848\uff08t_userfiles\uff09\u4fe1\u606f\uff0c\u7b2c" + pageIndex + "\u9875*****"));
                        for (int i = 0; i < userfilesArray.length(); ++i) {
                            JSONObject userfilesObject = userfilesArray.getJSONObject(i);
                            this.redisUtil.setHash("meter-" + userfilesObject.get("f_user_id"), userfilesObject);
                            JSONArray userInfoArray = this.sqlServer.query("redisGetUserInfo", new JSONObject().put("userInfo_id", userfilesObject.get("f_userinfo_id")), Integer.valueOf(1));
                            if (userInfoArray.length() != 1) continue;
                            JSONObject userInfoObject = userInfoArray.getJSONObject(0);
                            this.redisUtil.setHash("user-" + userInfoObject.get("f_userinfo_id"), userInfoObject);
                        }
                        LOGGER.debug((Object)("*****\u8868\u6863\u6848\uff08t_userfiles\uff09\u4fe1\u606f\u7b2c" + pageIndex + "\u9875\u52a0\u8f7d\u5b8c\u6210*****"));
                        ++pageIndex;
                    }
                    LOGGER.debug((Object)("*****\u6a21\u5757\u3010" + moduleName + "\u3011\u52a0\u8f7dRedis\u6570\u636e\u5b8c\u6210*****"));
                    continue;
                }
                finally {
                    TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.sessionFactory);
                    session.close();
                    continue;
                }
            }
            LOGGER.warn((Object)("*****\u6a21\u5757\u3010" + moduleName + "\u3011\u8df3\u8fc7Redis\u6570\u636e\u52a0\u8f7d*****"));
        }
    }
}

