/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.lanbaoshinewsystem;

import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.af.plugins.RestTools;
import com.aote.webmeter.module.qinchuan.Encryption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class Tools {
    @Autowired
    private static Logger logger = Logger.getLogger(Tools.class);
    private Date expirationTime = null;
    private String token;

    public boolean isToken() {
        return this.expirationTime != null && this.expirationTime.compareTo(DateTools.getNow()) > 0;
    }

    public boolean initToken(String url, String loginName, String pwd, JSONObject header) {
        JSONObject object = null;
        JSONObject content = new JSONObject();
        try {
            content.put("loginName", (Object)loginName);
            content.put("pwd", (Object)Encryption.MD5Encryption(pwd));
            String s = RestTools.post((String)(url + "?loginName=" + loginName + "&pwd=" + Encryption.MD5Encryption(pwd)), (JSONObject)content, (JSONObject)header);
            object = JsonTools.convertToJson((String)s);
            if ("success".equals(object.getString("State"))) {
                JSONObject data = object.getJSONObject("Data");
                String expiration = data.getString("expiration");
                expiration = expiration.substring(0, expiration.lastIndexOf(46));
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                long time = formatter.parse(expiration).getTime();
                this.expirationTime = new Date(time);
                this.token = data.getString("token");
                return true;
            }
            logger.warn((Object)object);
            return false;
        }
        catch (Throwable e) {
            logger.error((Object)"\u52a0\u8f7dToken\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            logger.error((Object)"URL");
            logger.error((Object)(url + "?loginName=" + loginName + "&pwd=" + Encryption.MD5Encryption(pwd)));
            logger.error((Object)"Header");
            logger.error((Object)header);
            logger.error((Object)"Content");
            logger.error((Object)content);
            if (object != null) {
                logger.error((Object)("\u63a5\u53e3\u8fd4\u56de\u6d88\u606f:" + object));
            }
            return false;
        }
    }

    public String formatDate(String date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date creationTime = formatter.parse(date);
            return formatter.format(creationTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return date;
        }
    }

    public JSONObject sendInstruct(String url, JSONObject header, JSONObject content) {
        try {
            String instructResult = RestTools.post((String)url, (JSONObject)content, (JSONObject)header);
            JSONObject ret = JsonTools.convertToJson((String)instructResult);
            return ret;
        }
        catch (Throwable e) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("State", (Object)"fail");
            jsonObject.put("Message", (Object)"\u63a5\u53e3\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38");
            jsonObject.put("Data", (Object)"");
            return jsonObject;
        }
    }

    public JSONObject formatPriceDetails(JSONArray prices) {
        int i;
        Double[] retPrices = new Double[5];
        Integer[] retGas = new Integer[5];
        retPrices[0] = 1.0;
        retGas[0] = 65535;
        for (i = 0; i < prices.length(); ++i) {
            retPrices[i] = prices.getJSONObject(i).getDouble("f_price");
            retGas[i] = prices.getJSONObject(i).getInt("f_gas");
        }
        int n = i = prices.length() == 0 ? 1 : prices.length();
        while (i < retPrices.length) {
            retPrices[i] = retPrices[i - 1];
            retGas[i] = retGas[i - 1];
            ++i;
        }
        JSONObject ret = new JSONObject();
        for (int i2 = 0; i2 < retPrices.length; ++i2) {
            ret.put("price" + (i2 + 1), (Object)retPrices[i2]);
            ret.put("gas" + (i2 + 1), (Object)retGas[i2]);
        }
        return ret;
    }

    public String getCtrlTimeout(String date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date creationTime = formatter.parse(date);
            Calendar c = Calendar.getInstance();
            c.setTime(creationTime);
            c.add(5, 3);
            return formatter.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String genCommandId() {
        StringBuffer str = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            str.append(random.nextInt(10));
        }
        return str.toString();
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

