/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.laidenb.parsedata;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;

public class Util {
    public static String bcd2Str(byte[] bytes) {
        StringBuffer temp = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            temp.append((byte)((bytes[i] & 0xF0) >>> 4));
            temp.append((byte)(bytes[i] & 0xF));
        }
        return "0".equalsIgnoreCase(temp.toString().substring(0, 1)) ? temp.toString().substring(1) : temp.toString();
    }

    public static byte[] StrToBCDBytes(String s) {
        if (s.length() % 2 != 0) {
            s = "0" + s;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        char[] cs = s.toCharArray();
        for (int i = 0; i < cs.length; i += 2) {
            int high = cs[i] - 48;
            int low = cs[i + 1] - 48;
            baos.write(high << 4 | low);
        }
        return baos.toByteArray();
    }

    public static String hexToAscii(String hexStr) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < hexStr.length(); i += 2) {
            String str = hexStr.substring(i, i + 2);
            output.append((char)Integer.parseInt(str, 16));
        }
        return output.toString();
    }

    public static int convertToDecimal(String binary) {
        return Integer.valueOf(binary, 2);
    }

    public static String stringToAscii(String value) {
        StringBuffer sbu = new StringBuffer();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i != chars.length - 1) {
                sbu.append((int)chars[i]).append(",");
                continue;
            }
            sbu.append((int)chars[i]);
        }
        return sbu.toString();
    }

    public static String asciiToString(String value) {
        StringBuffer sbu = new StringBuffer();
        String[] chars = value.split(",");
        for (int i = 0; i < chars.length; ++i) {
            sbu.append((char)Integer.parseInt(chars[i]));
        }
        return sbu.toString();
    }

    public static String makeChecksum1(String data) {
        if (data == null || "".equals(data)) {
            return "";
        }
        int total = 0;
        int len = data.length();
        for (int num = 0; num < len; num += 2) {
            String s = data.substring(num, num + 2);
            total += Integer.parseInt(s, 16);
        }
        int mod = total % 256;
        String hex = Integer.toHexString(mod);
        len = hex.length();
        if (len < 2) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static String makeChecksum(String hexdata, int len) {
        if (hexdata == null || "".equals(hexdata)) {
            return "00";
        }
        hexdata = hexdata.replaceAll(" ", "");
        int total = 0;
        if (len % 2 != 0) {
            return "00";
        }
        for (int num = 0; num < len; num += 2) {
            String s = hexdata.substring(num, num + 2);
            total += Integer.parseInt(s, 16);
        }
        return Util.hexInt(total);
    }

    private static String hexInt(int total) {
        int a = total / 256;
        int b = total % 256;
        if (a > 255) {
            return Util.hexInt(a) + Util.format(b);
        }
        return Util.format(a) + Util.format(b);
    }

    private static String format(int hex) {
        String hexa = Integer.toHexString(hex);
        int len = hexa.length();
        if (len < 2) {
            hexa = "0" + hexa;
        }
        return hexa;
    }

    private static String makeCheckSum(String data, int length) {
        int dSum = 0;
        for (int index = 0; index < length; index += 2) {
            String s = data.substring(index, index + 2);
            dSum += Integer.parseInt(s, 16);
        }
        int mod = dSum % 256;
        String checkSumHex = Integer.toHexString(mod);
        length = checkSumHex.length();
        if (length < 2) {
            checkSumHex = "0" + checkSumHex;
        }
        return checkSumHex;
    }

    public static byte[] intToByteArray(int a) {
        if (a < 0) {
            a += 256;
        }
        return new byte[]{(byte)(a >> 24 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
    }

    public static int byteArrayToInt(byte[] bytes) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (bytes[i] & 0xFF) << shift;
        }
        return value;
    }

    public static int HexToInt(byte[] Hex, int Count) {
        int Result = 0;
        for (int i = 0; i < Count; ++i) {
            Result = Result << 8 | Hex[i] & 0xFF;
        }
        return Result;
    }

    public static byte[] str2Bcd(String asc) {
        int len = asc.length();
        int mod = len % 2;
        if (mod != 0) {
            asc = "0" + asc;
            len = asc.length();
        }
        byte[] abt = new byte[len];
        if (len >= 2) {
            len /= 2;
        }
        byte[] bbt = new byte[len];
        abt = asc.getBytes(StandardCharsets.US_ASCII);
        for (int p = 0; p < asc.length() / 2; ++p) {
            byte b;
            int j = abt[2 * p] >= 48 && abt[2 * p] <= 57 ? abt[2 * p] - 48 : (abt[2 * p] >= 97 && abt[2 * p] <= 122 ? abt[2 * p] - 97 + 10 : abt[2 * p] - 65 + 10);
            int k = abt[2 * p + 1] >= 48 && abt[2 * p + 1] <= 57 ? abt[2 * p + 1] - 48 : (abt[2 * p + 1] >= 97 && abt[2 * p + 1] <= 122 ? abt[2 * p + 1] - 97 + 10 : abt[2 * p + 1] - 65 + 10);
            int a = (j << 4) + k;
            bbt[p] = b = (byte)a;
        }
        return bbt;
    }

    public static final String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public static final String byteToHexString(byte bArray) {
        StringBuffer sb = new StringBuffer(1);
        String sTemp = Integer.toHexString(0xFF & bArray);
        if (sTemp.length() < 2) {
            sb.append(0);
        }
        sb.append(sTemp.toUpperCase());
        return sb.toString();
    }

    public static String str2HexStr(String str) {
        char[] chars = "0123456789ABCDEF".toCharArray();
        StringBuilder sb = new StringBuilder();
        byte[] bs = str.getBytes();
        for (int i = 0; i < bs.length; ++i) {
            int bit = (bs[i] & 0xF0) >> 4;
            sb.append(chars[bit]);
            bit = bs[i] & 0xF;
            sb.append(chars[bit]);
        }
        return sb.toString();
    }

    public static String Int2Hex(int integer) {
        StringBuffer buf = new StringBuffer(2);
        if ((integer & 0xFF) < 16) {
            buf.append("0");
        }
        buf.append(Long.toString(integer & 0xFF, 16));
        return buf.toString();
    }

    public static String byteArrToBinStr(byte[] b) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            result.append(Long.toString(b[i] & 0xFF, 2) + ",");
        }
        return result.toString().substring(0, result.length() - 1);
    }

    public static byte[] toByteArray(String hexString) {
        if (StringUtils.isEmpty((String)hexString)) {
            return null;
        }
        hexString = hexString.toLowerCase();
        byte[] byteArray = new byte[hexString.length() >> 1];
        int index = 0;
        for (int i = 0; i < hexString.length(); ++i) {
            if (index > hexString.length() - 1) {
                return byteArray;
            }
            byte highDit = (byte)(Character.digit(hexString.charAt(index), 16) & 0xFF);
            byte lowDit = (byte)(Character.digit(hexString.charAt(index + 1), 16) & 0xFF);
            byteArray[i] = (byte)(highDit << 4 | lowDit);
            index += 2;
        }
        return byteArray;
    }

    public static byte[] hexToByteArray(String inHex) {
        byte[] result;
        int hexlen = inHex.length();
        if (hexlen % 2 == 1) {
            result = new byte[++hexlen / 2];
            inHex = "0" + inHex;
        } else {
            result = new byte[hexlen / 2];
        }
        int j = 0;
        for (int i = 0; i < hexlen; i += 2) {
            result[j] = Util.hexToByte(inHex.substring(i, i + 2));
            ++j;
        }
        return result;
    }

    public static byte hexToByte(String inHex) {
        return (byte)Integer.parseInt(inHex, 16);
    }
}

