/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.cangnantcp;

import java.util.Arrays;

public class HexUtils {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static char[] encodeHex(byte[] data) {
        return HexUtils.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return HexUtils.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexStr(byte[] data) {
        return HexUtils.encodeHexStr(data, false);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return HexUtils.encodeHexStr(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(HexUtils.encodeHex(data, toDigits));
    }

    public static byte[] decodeHex(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexUtils.toDigit(data[j], j) << 4;
            f |= HexUtils.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static String AToString(int i) {
        return Character.toString((char)i);
    }

    public static String StringToA(String content) {
        String result = "";
        int max = content.length();
        for (int i = 0; i < max; ++i) {
            char c;
            char b = c = content.charAt(i);
            result = result + b;
        }
        return result;
    }

    public static String asciiHexStr2Str(String str) {
        StringBuffer sb = new StringBuffer();
        int index = 0;
        if (str.length() % 2 == 0) {
            for (int i = 0; i < str.length() / 2; ++i) {
                int decimal = Integer.parseInt(str.substring(index, index + 2));
                if (decimal - 30 >= 0 && decimal - 30 <= 9) {
                    sb.append(decimal - 30);
                }
                index += 2;
            }
        }
        return sb.toString();
    }

    public static byte[] str2Bcd(String asc) {
        int len = asc.length();
        int mod = len % 2;
        if (mod != 0) {
            asc = "0" + asc;
            len = asc.length();
        }
        if (len >= 2) {
            len /= 2;
        }
        byte[] bbt = new byte[len];
        byte[] abt = asc.getBytes();
        for (int p = 0; p < asc.length() / 2; ++p) {
            byte b;
            int j = abt[2 * p] >= 48 && abt[2 * p] <= 57 ? abt[2 * p] - 48 : (abt[2 * p] >= 97 && abt[2 * p] <= 122 ? abt[2 * p] - 97 + 10 : abt[2 * p] - 65 + 10);
            int k = abt[2 * p + 1] >= 48 && abt[2 * p + 1] <= 57 ? abt[2 * p + 1] - 48 : (abt[2 * p + 1] >= 97 && abt[2 * p + 1] <= 122 ? abt[2 * p + 1] - 97 + 10 : abt[2 * p + 1] - 65 + 10);
            int a = (j << 4) + k;
            bbt[p] = b = (byte)a;
        }
        return bbt;
    }

    public static byte[] toBytes(String str) {
        if (str == null || "".equals(str.trim())) {
            return new byte[0];
        }
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < str.length() / 2; ++i) {
            String subStr = str.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte)Integer.parseInt(subStr, 16);
        }
        return bytes;
    }

    public static String encode(String str) throws Exception {
        String hexString = "0123456789ABCDEF";
        byte[] bytes = str.getBytes("GBK");
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(hexString.charAt((bytes[i] & 0xF0) >> 4));
            sb.append(hexString.charAt((bytes[i] & 0xF) >> 0));
        }
        return sb.toString();
    }

    public static long getLong(byte[] arr, int index) {
        return 0xFF00000000000000L & (long)arr[index + 0] << 56 | 0xFF000000000000L & (long)arr[index + 1] << 48 | 0xFF0000000000L & (long)arr[index + 2] << 40 | 0xFF00000000L & (long)arr[index + 3] << 32 | 0xFF000000L & (long)arr[index + 4] << 24 | 0xFF0000L & (long)arr[index + 5] << 16 | 0xFF00L & (long)arr[index + 6] << 8 | 0xFFL & (long)arr[index + 7];
    }

    public static double bytes2Double(byte[] arr) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value |= (long)(arr[i] & 0xFF) << 8 * i;
        }
        return Double.longBitsToDouble(value);
    }

    public static float bytesToFloat(byte[] data) {
        int s = 0;
        float f = 0.0f;
        int e = 0;
        s = (data[3] & 0xFF) >= 128 ? -1 : 1;
        int temp = (data[2] & 0xFF) >= 128 ? 1 : 0;
        e = (data[3] & 0xFF) % 128 * 2 + temp;
        float[] data2 = new float[]{data[0] & 0xFF, data[1] & 0xFF, data[2] & 0xFF};
        f = (data2[2] - (float)(temp * 128) + 128.0f) / 128.0f + data2[1] / 32768.0f + data2[0] / 8388608.0f;
        if (e == 0 && f != 0.0f) {
            float result = (float)((double)((float)s * (f - 1.0f)) * Math.pow(2.0, -126.0));
            return result;
        }
        if (e == 0) {
            float result = 0.0f;
            return result;
        }
        if (s == 0 && e == 255 && f == 0.0f) {
            float result = 1111.11f;
            return result;
        }
        float result = s == 1 && e == 255 && f == 0.0f ? -1111.11f : (float)((double)((float)s * f) * Math.pow(2.0, e - 127));
        return result;
    }

    public static String bytes2BinaryStr(byte[] bytes) {
        StringBuffer binaryStr = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String str = Integer.toBinaryString((bytes[i] & 0xFF) + 256).substring(1);
            binaryStr.append(str);
        }
        return binaryStr.toString();
    }

    public static float bytes2Float(byte[] bytes) {
        String binaryStr = HexUtils.bytes2BinaryStr(bytes);
        Long s = Long.parseLong(binaryStr.substring(0, 1));
        Long e = Long.parseLong(binaryStr.substring(1, 9), 2);
        String M = binaryStr.substring(9);
        float m = 0.0f;
        for (int i = 0; i < M.length(); ++i) {
            float a = Integer.parseInt(M.charAt(i) + "");
            float b = (float)Math.pow(2.0, i + 1);
            m += a / b;
        }
        return (float)(Math.pow(-1.0, s.longValue()) * (double)(1.0f + m) * Math.pow(2.0, e - 127L));
    }

    public static void main(String[] args) {
        String ascii = "31323334353637383930310000000000";
        System.out.println(HexUtils.asciiHexStr2Str(ascii));
        System.out.println(Arrays.toString(HexUtils.str2Bcd("2D877BE0")));
        System.out.println(HexUtils.encodeHex(HexUtils.str2Bcd("2D877BE0"), true));
        System.out.println(Arrays.toString(HexUtils.str2Bcd("40658000")));
        System.out.println(HexUtils.encodeHex(HexUtils.str2Bcd("40658000"), true));
        String dFloat = "4065800000000000";
        String sFloat = "41A00000";
        System.out.println(Double.longBitsToDouble(Long.valueOf(dFloat, 16)));
        System.out.println(Float.intBitsToFloat(Integer.valueOf(sFloat, 16)));
        System.out.println(Integer.valueOf(sFloat, 16));
    }
}

