select
  tc.f_changemeter_type,
  tc.f_gasbrand_id,
  tc.f_newgasbrand_id,
  tc.f_newgasmodel_id,
  tc.f_gasmodel_id,
  tc.f_newmeter_base,
  tc.f_userinfo_id,
  convert(varchar ,tu.f_user_id) f_user_id,
  tu.f_sync_user_id,
  ts.f_version-100 f_version,
  tc.id,
  tu.version,
  t.f_user_name,
  tu.f_meternumber,
  tu.f_meternumber f_card_id,
  ts.id f_priceid,
  ts.f_price_id,
  tu.f_userinfo_id f_address_id,
  t.f_user_phone f_phone,
  tm.f_rated_traffic Metercategory,
  case tm.f_meter_style
    when 'NB20E' then '20'
    when 'NB20F' then 'FE'
    else '99'
    end Metertype,
  t.f_filiale,
  t.f_outlets,
  t.f_orgstr
from t_changemeter tc
LEFT JOIN t_userfiles tu on tc.f_user_id = tu.f_user_id
left join t_userinfo t on tu.f_userinfo_id = t.f_userinfo_id
left join t_gasbrand tg on tu.f_gasbrand_id = tg.id
left join t_gasmodel tm on tg.id = tm.f_gasbrand_id and tu.f_gasmodel_id = tm.id
left join t_stairprice ts on tu.f_price_id = ts.f_price_id
where tg.f_alias = '{f_meter_brand}'
  AND t.f_user_state = '正常'
  AND tu.f_table_state <> '停用'
  AND ts.f_state = '有效'
  AND (tc.f_sendsuccess is null or tc.f_sendsuccess <> '成功')
  AND DATEDIFF(day,getDate(),tc.f_changemeter_date) >= 0
order by tc.id desc