SELECT
	t_fillgas.id,
	t_fillgas.f_fillgas,
	t_fillgas.f_fillgas_fee,
	s.id f_stairprice_id,
	u.f_meternumber,
	u.f_times,
	u.f_total_fee,
	u.f_user_id,
	u.f_card_id,
	u.f_userinfo_id,
	u.f_imei,
	u.f_show_way,
	SUBSTRING (
		CONVERT (
			VARCHAR (100),
			s.f_perform_date,
			10
		),
		0,
		6
	) AS start_date,
	isnull(s.f_stairmonths, 1) f_stairmonths,
	m.f_billing f_display_type
FROM
	t_fillgas
LEFT JOIN t_userfiles u ON u.f_user_id = t_fillgas.f_user_id
LEFT JOIN t_changemeter c ON c.f_fillgas_id = t_fillgas.id
LEFT JOIN t_gasbrand g ON u.f_gasbrand_id = g.ID
LEFT JOIN t_stairprice s ON s.f_price_id = u.f_price_id
AND u.f_orgid = s.f_filialeid
LEFT JOIN t_gasmodel m ON u.f_gasmodel_id = m.id
WHERE
	t_fillgas.f_fillgas_state = '有效'
AND (
	t_fillgas.f_sendsuccess <> '成功'
	OR t_fillgas.f_sendsuccess IS NULL
)
AND (
	t_fillgas.f_fillgas_type = '换表补气'
	OR t_fillgas.f_fillgas_type = '清零补气'
)
AND t_fillgas.f_fillgas_date >= c.f_operate_date
AND g.f_alias = '{f_meter_brand}'
AND u.f_sendsuccess = '成功'
AND s.f_state = '有效'
AND u.f_show_way = '已开户'
AND c.f_is_open = '是'
AND s.f_version = (
	SELECT
		MAX (f_version)
	FROM
		t_stairprice b
	WHERE
		s.f_price_id = b.f_price_id
)
AND getdate() >= s.f_perform_date
AND getdate() <= s.f_end_date