SELECT t_changetables.id                             id,
       t_changetables.f_user_id                      f_user_id,
       t_changetables.f_userfiles_id_old             f_userfiles_id_old,
       t_changetables.f_userinfo_id                  f_userinfo_id,
       t_gasbrand.f_alias                            f_alias,
       t_changetables.f_meternumber_old              f_meternumber,
       t_changetables.f_meternumber                  f_newmeternumber,
       t_gasbrand.f_manufacturers                    f_manufacturers,
       isnull(s.f_stairmonths, 1)                    f_stairmonths,
       isnull(s.f_stair_start_date,s.f_perform_date) start_date,
       tu.f_filialeid,
       tu.f_orgid,
       tu.f_depid,
       tu.f_orgname,
       tu.f_depname
FROM t_changetables
         LEFT JOIN t_userfiles tu on t_changetables.f_userfiles_id = tu.f_userfiles_id
         LEFT JOIN t_gasbrand ON t_changetables.f_gasbrand_id_old = t_gasbrand.id
         LEFT JOIN t_stairprice s ON s.f_price_id = tu.f_price_id and tu.f_filialeid = s.f_filialeid
WHERE (t_changetables.f_sendsuccess <> '成功' OR t_changetables.f_sendsuccess IS NULL)
  AND tu.f_sendsuccess = '成功'
  AND t_gasbrand.f_alias = '{f_meter_brand}'
  AND s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  AND getdate() <= s.f_end_date

