SELECT t_pricechange.id,
       u.f_user_id,
       u.f_price_id,
       s.id                       f_stairprice_id,
       u.f_meternumber,
       isnull(s.f_stairmonths, 1) f_stairmonths
FROM t_pricechange
         INNER JOIN t_userfiles u ON u.f_userinfo_id = t_pricechange.f_userinfo_id
         LEFT JOIN t_gasbrand g ON u.F_GASBRAND_ID = g.ID
         LEFT JOIN t_stairprice s ON s.f_price_id = u.f_price_id
WHERE s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  and getdate() <= s.f_end_date
  AND (t_pricechange.F_SENDSUCCESS <> '成功' OR t_pricechange.F_SENDSUCCESS IS NULL)
  AND g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
ORDER BY ID DESC
