select tu.f_user_id   f_user_id,
       tu.f_userinfo_id,
       t.f_user_name,
       t.f_user_phone f_phone,
       tu.f_meternumber,
       ts.f_price_id  f_price_id,
       ts.f_version   pricenum,
       tua.id         f_address_id,
       case tm.f_meter_style
           when 'G1.6' then '1.6'
           when 'G2.5' then '2.5'
           when 'G4' then '4'
           when 'G6' then '6'
           when 'G10' then '10'
           when 'G16' then '16'
           when 'G25' then '25'
           when 'G40' then '40'
           else '99'
           end        metertype
from t_userfiles tu
         left join t_userinfo t on tu.f_userinfo_id = t.f_userinfo_id
         left join t_user_address tua on tu.f_useraddress_id = tua.id
         left join t_gasbrand tg on tu.f_gasbrand_id = tg.id
         left join t_gasmodel tm on tm.id = tu.f_gasmodel_id
         left join t_stairprice ts on ts.f_price_id = tu.f_price_id and tu.f_orgid = ts.f_orgid
WHERE tg.f_alias = '{f_meter_brand}'
  AND t.f_user_state = '正常'
  AND tua.f_sendsuccess = '成功'
  AND tu.f_table_state <> '停用'
  AND ts.f_state = '有效'
  AND getdate() >= ts.f_perform_date
  AND getdate() <= ts.f_end_date
  AND ts.f_sync_sendsuccess = '成功'
  AND (
        tu.f_sync_sendsuccess <> '成功'
        OR tu.f_sync_sendsuccess IS NULL
    )
