SELECT t_fillgas.id                              sellid,
       u.f_user_id                               customer_code,
       t_fillgas.f_fillgas_fee                   money,
       u.f_balance_amount                        account_money,
       'JF' + CONVERT(VARCHAR(20), t_fillgas.id) cid,
       t_fillgas.f_operator                      operator,
       t_fillgas.f_fillgas_date                  charge_date,
       1                                         charge_count_num,
       st.id                                     stairprice_id,
       u.f_price_id                              price_id,
       u.f_userinfo_id                           f_userinfo_id,
       'fillgas'                                 type,
       u.f_orgid
FROM t_fillgas
         LEFT JOIN t_userfiles u ON u.f_user_id = t_fillgas.f_user_id
         LEFT JOIN t_gasbrand g ON u.f_gasbrand_id = g.ID
         LEFT JOIN t_stairprice st ON st.f_price_id = u.f_price_id and u.f_filialeids = st.f_filialeids
where t_fillgas.f_fillgas_state = '有效'
  AND t_fillgas.f_fillgas_type = '换表补气'
  AND (t_fillgas.F_SENDSUCCESS <> '成功' OR t_fillgas.F_SENDSUCCESS IS NULL)
  AND g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND st.f_state = '有效'
  AND getdate() >= st.f_perform_date
  AND getdate() <= st.f_end_date
