SELECT ts.id                              sellid,
       tf.f_user_id                       customer_code,
       ts.f_collection                    money,
       tf.f_balance_amount                account_money,
       'JF' + CONVERT(VARCHAR(20), ts.id) cid,
       ts.f_operator                      operator,
       ts.f_delivery_date                 charge_date,
       ts.f_times                         charge_count_num,
       st.id                              stairprice_id,
       tf.f_price_id                      price_id,
       tf.f_userinfo_id                   f_userinfo_id,
       'selling'                          type,
       tf.f_orgid
FROM t_sellinggas ts
         LEFT JOIN t_userfiles tf ON ts.f_user_id = tf.f_user_id
         LEFT JOIN t_gasbrand tg ON tf.f_gasbrand_id = tg.id
         LEFT JOIN t_stairprice st ON st.f_price_id = tf.f_price_id and tf.f_filialeids = st.f_filialeids
WHERE ts.f_charge_state = '有效'
  AND (ts.f_sendsuccess <> '成功' OR ts.f_sendsuccess IS NULL)
  AND tg.f_alias = '{f_meter_brand}'
  AND tf.f_sendsuccess = '成功'
  AND ts.f_charge_type IN ('物联网收费', '退费')
  AND st.f_state = '有效'
  AND getdate() >= st.f_perform_date
  AND getdate() <= st.f_end_date
