/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot;

import com.af.plugins.HttpConnectionPoolUtil;
import com.aote.webmeter.enums.TelecomApiEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.SignalDeliveryTools;
import com.iotplatform.client.NorthApiException;
import com.iotplatform.client.dto.AuthOutDTO;
import com.iotplatform.constant.AuthConstant;
import com.iotplatform.constant.ExceptionEnum;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class AuthenticationTools {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationTools.class);
    private static final Map<String, Long> STAMP = new ConcurrentHashMap<String, Long>();
    private static final Map<String, String> AOD = new ConcurrentHashMap<String, String>();
    private static final Integer TOKEN_TIMEOUT_VALUE = 1800000;
    private static CloseableHttpClient httpClient;

    public static CloseableHttpClient getHttpClient() {
        if (httpClient == null) {
            AuthenticationTools.setHttpClient();
        }
        return httpClient;
    }

    private static synchronized void setHttpClient() {
        try {
            httpClient = HttpConnectionPoolUtil.getHttpClient((LayeredConnectionSocketFactory)AuthenticationTools.initSslConfig());
        }
        catch (NorthApiException e) {
            e.printStackTrace();
        }
    }

    public static String getAuthToken() {
        long current = System.currentTimeMillis();
        String apiKey = WebMeterInfo.getString("telecomAPIKey");
        String accessToken = AOD.get(apiKey);
        Long stampValue = STAMP.get(apiKey);
        if (accessToken != null && stampValue != null && current - stampValue < (long)TOKEN_TIMEOUT_VALUE.intValue()) {
            LOGGER.info((Object)(apiKey + ":\u83b7\u53d6\u73b0\u6709token"));
            return accessToken;
        }
        try {
            return AuthenticationTools.getWebAuthToken();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getWebAuthToken() throws IOException {
        String appId = WebMeterInfo.getString("telecomAPIKey");
        String secret = WebMeterInfo.getString("telecomSecret");
        LOGGER.info((Object)(appId + ":\u8fdb\u884c\u9274\u6743\u64cd\u4f5c"));
        HashMap<String, String> paramCommand = new HashMap<String, String>(2);
        paramCommand.put("appId", appId);
        paramCommand.put("secret", secret);
        String responseBody = HttpConnectionPoolUtil.requestFormUrlEncoded((String)TelecomApiEnum.AUTH_URL.getValue(), paramCommand, (HttpEntityEnclosingRequestBase)new HttpPost(), (CloseableHttpClient)httpClient);
        AuthOutDTO authOutDTO = new AuthOutDTO();
        authOutDTO.setAccessToken(new JSONObject(responseBody).getString("accessToken"));
        String newAccessToken = authOutDTO.getAccessToken();
        AOD.put(appId, newAccessToken);
        STAMP.put(appId, System.currentTimeMillis());
        return newAccessToken;
    }

    protected static SSLConnectionSocketFactory initSslConfig() throws NorthApiException {
        try {
            InputStream isTrustCa = SignalDeliveryTools.class.getResourceAsStream("/ca.jks");
            InputStream isSelfCert = SignalDeliveryTools.class.getResourceAsStream("/outgoing.CertwithKey.pkcs12");
            KeyStore selfCert = KeyStore.getInstance("pkcs12");
            selfCert.load(isSelfCert, AuthConstant.SELFCERTPWD.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("sunx509");
            kmf.init(selfCert, AuthConstant.SELFCERTPWD.toCharArray());
            KeyStore caCert = KeyStore.getInstance("jks");
            caCert.load(isTrustCa, AuthConstant.TRUSTCAPWD.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("sunx509");
            tmf.init(caCert);
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sc, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            isTrustCa.close();
            isSelfCert.close();
            return sslConnectionSocketFactory;
        }
        catch (Exception var10) {
            throw new NorthApiException(ExceptionEnum.CLIENT_SSL_CONFIG_ERROR, var10.getMessage());
        }
    }

    static {
        AuthenticationTools.setHttpClient();
    }
}

