/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.aote.webmeter.tools.Util;
import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class BasicTools {
    private static final Logger LOGGER;
    private static final String PORT;
    private static final String LOCAL_URL;

    public static String getPort() {
        return PORT != null ? PORT : "8445";
    }

    public static String getLocalUrl() {
        return LOCAL_URL != null ? LOCAL_URL : "http://localhost:8445";
    }

    public static void sleep(Integer millis) throws InterruptedException {
        Thread.sleep(millis.intValue());
    }

    public static JSONArray formatStairArray(JSONObject object) {
        JSONArray result = new JSONArray();
        for (int i = 1; i <= object.length(); ++i) {
            if (!object.has("f_stair" + i + "price")) continue;
            JSONObject stair = new JSONObject();
            stair.put("f_price", (Object)Util.convertBigDecimal(object.get("f_stair" + i + "price")));
            stair.put("f_gas", (Object)Util.convertBigDecimal(object.get("f_stair" + i + "amount")));
            result.put((Object)stair);
        }
        return BasicTools.formatStairArray(result);
    }

    public static JSONArray formatStairArray(JSONArray array) {
        JSONArray result = new JSONArray();
        JSONObject item = null;
        int length = array.length();
        if (length < 3) {
            length = 3;
        }
        for (int i = 0; i < length; ++i) {
            if (array.length() >= i + 1) {
                item = array.getJSONObject(i);
                int gas = item.getInt("f_gas");
                if (gas > 65565 || gas <= 0) {
                    item.put("f_gas", 6553 + i);
                }
                result.put((Object)item);
                continue;
            }
            if (item == null) continue;
            item.put("f_gas", 6553 + i);
            result.put((Object)item);
        }
        return result;
    }

    static {
        boolean isOK;
        LOGGER = Logger.getLogger(BasicTools.class);
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = null;
        try {
            objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("org.apache.coyote.http11.Http11AprProtocol")));
            isOK = true;
        }
        catch (Exception e) {
            try {
                objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
                isOK = true;
            }
            catch (MalformedObjectNameException e2) {
                LOGGER.error((Object)"\u83b7\u53d6\u670d\u52a1\u7aef\u53e3\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a");
                isOK = false;
            }
        }
        PORT = isOK && objectNames.iterator().hasNext() ? objectNames.iterator().next().getKeyProperty("port") : "8445";
        LOCAL_URL = "http://localhost:" + PORT + "/webmeter/";
        LOGGER.debug((Object)("\u672c\u5730Tomcat\u670d\u52a1\u5730\u5740\uff1a" + LOCAL_URL));
    }
}

