/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.weisidaflowmeter;

import com.af.plugins.CommonTools;
import com.yd.entity.Command;
import com.yd.resolver.ValveResolver;
import com.yd.utils.DataUtils;
import com.yd.utils.HexStringUtils;
import com.yd.utils.ModBusUtils;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class Tool {
    public static String getSetLakeCode(String value) {
        int temp = 0;
        try {
            temp = Integer.parseInt(value);
            if (temp <= 0) {
                return "0000";
            }
            String s = String.format("%4s", Integer.toHexString(temp));
            return s.replace(' ', '0');
        }
        catch (Exception e) {
            return "0000";
        }
    }

    public static String getSetTimeCode(String version, String value) {
        String hour = value.substring(0, 2);
        Integer iHour = Integer.parseInt(hour);
        String minute = value.substring(2, 4);
        int iMinute = Integer.parseInt(minute);
        hour = String.format("%2s", Integer.toHexString(iHour));
        hour = hour.replace(' ', '0');
        minute = String.format("%2s", Integer.toHexString(iMinute));
        minute = minute.replace(' ', '0');
        String ret = "3".equals(version) ? hour + minute : minute + hour;
        return ret;
    }

    public String getCRC(String command) {
        return HexStringUtils.bytesToHexString((byte[])ModBusUtils.getData((byte[])HexStringUtils.hexStringToBytes((String)command)));
    }

    public static JSONObject resolve(String name, String Response) throws Exception {
        Command command = new Command();
        command.setName(name);
        command.setResponse(Response);
        ValveResolver vResolver = new ValveResolver();
        Map map = vResolver.resolve(command);
        JSONObject jsonObject = new JSONObject(map);
        if ("query_coil_status".equals(name)) {
            String temp = jsonObject.getString("battery");
            jsonObject.put("inner_battery", (Object)temp.substring(temp.indexOf("\uff1a") + 1, temp.indexOf(";")));
            jsonObject.put("outer_battery", (Object)temp.substring(temp.lastIndexOf("\uff1a") + 1));
        }
        return jsonObject;
    }

    public static JSONObject resolveUpData(String data) throws Exception {
        Map result = data != null && data.length() == 52 ? DataUtils.resolveUpData((String)data) : (data != null && data.length() >= 84 ? DataUtils.resolveUpDataNew((String)data) : null);
        return new JSONObject(result);
    }

    public JSONObject resolveValveStatus(String temp) {
        JSONObject jsonObject = new JSONObject();
        if (temp == null || "".equals(temp)) {
            jsonObject.put("inner_battery", (Object)"normal");
            jsonObject.put("outer_battery", (Object)"normal");
            return jsonObject;
        }
        jsonObject.put("inner_battery", (Object)temp.substring(temp.indexOf("\uff1a") + 1, temp.indexOf(";")));
        jsonObject.put("outer_battery", (Object)temp.substring(temp.lastIndexOf("\uff1a") + 1));
        return jsonObject;
    }

    public static String resolveHourGas(String response) {
        if ((response = response.replaceAll(" ", "")) == null) {
            return "";
        }
        if (response.length() != 106) {
            return "";
        }
        JSONArray jsonArray = new JSONArray();
        response.substring(2, 4);
        for (int i = 0; i < 24; ++i) {
            jsonArray.put((Object)CommonTools.div((Object)Integer.parseInt(response.substring(i * 4 + 6, i * 4 + 10), 16), (Object)100));
        }
        return jsonArray.toString();
    }

    public static String getHex8Money(String dec) {
        double money = Double.parseDouble(dec);
        if (money <= 0.0) {
            return "00000000";
        }
        long moneyI = (long)(money * 100.0);
        if (moneyI > 0xFFFFFFFFL) {
            return "ffffffff";
        }
        String s = String.format("%8s", Long.toHexString(moneyI));
        return s.replace(' ', '0');
    }

    public static String getHex8MoneyOverdraft(String dec) {
        double money = Double.parseDouble(dec);
        if (!(money < 0.0)) {
            return "00000000";
        }
        long moneyI = (long)((money *= -1.0) * 100.0);
        if (moneyI > 0xFFFFFFFFL) {
            return "ffffffff";
        }
        String s = String.format("%8s", Long.toHexString(moneyI));
        return s.replace(' ', '0');
    }

    public static String getHex12Money(String dec) {
        double money = Double.parseDouble(dec);
        if (money <= 0.0) {
            return "000000000000";
        }
        long moneyI = (long)(money * 100.0);
        if (moneyI >= 0xFFFFFFFFFFFFL) {
            return "FFFFFFFFFFFF";
        }
        String s = String.format("%12s", Long.toHexString(moneyI));
        return s.replace(' ', '0');
    }

    public String getHex4Money(String dec) {
        double money = Double.parseDouble(dec);
        int moneyI = (int)(money * 100.0);
        String s = String.format("%4s", Integer.toHexString(moneyI));
        return s.replace(' ', '0');
    }

    public static String getCode(int day) {
        return Tool.getStartAddr(day) + "0002";
    }

    private static String getStartAddr(int day) {
        if (day == 0) {
            return "00cf";
        }
        if (day > 0 && day <= 30) {
            int value = day * 2 + 205;
            String ret = String.format("%4s", Integer.toHexString(value));
            return ret.replace(' ', '0');
        }
        return "0000";
    }

    public static void main(String[] args) {
        System.out.println(Tool.getHex8Money("900000000"));
        System.out.println(Tool.getHex12Money("900000000"));
    }
}

