/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.saifunb;

import com.af.plugins.CommonTools;
import com.aote.sql.SqlServer;
import com.aote.webmeter.module.saifunb.SaiFuInfo;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Exception.class})
public class SaiFuNBMeterTools {
    private static Logger log = Logger.getLogger(SaiFuNBMeterTools.class);
    @Autowired
    private SqlServer sqlServer;

    public void initialStairPriceInfo() throws Exception {
        WebMeterInfo.setModuleName("SaiFuNB");
        SaiFuInfo.setStairPriceDetailsInfo(this.getPriceDetailsInfo(null));
        SaiFuInfo.setStairPriceInfo(this.getPriceDateInfo(null));
    }

    public synchronized void updateStairPriceInfo(JSONArray jtInfo, JSONArray jtDateInfo) throws Exception {
        WebMeterInfo.setModuleName("SaiFuNB");
        SaiFuInfo.setStairPriceDetailsInfo(this.getPriceDetailsInfo(jtInfo));
        SaiFuInfo.setStairPriceInfo(this.getPriceDateInfo(jtDateInfo));
    }

    public JSONObject getStatus(JSONObject params, String useDateCode) {
        boolean result = true;
        JSONObject resultObject = new JSONObject();
        if (params.has("RTypeDate")) {
            StringBuilder oldDateArray = new StringBuilder(params.getString("RTypeDate"));
            StringBuilder newDateArray = new StringBuilder();
            JSONArray priceInfo = SaiFuInfo.getStairPriceInfo().getJSONArray(useDateCode);
            JSONObject index = this.getJtCodeOrIndex(priceInfo);
            String jtCode = String.valueOf(index.getInt("index"));
            String jtCode2 = String.valueOf(index.getInt("index2"));
            for (int i = 0; i < priceInfo.length(); ++i) {
                JSONObject object = priceInfo.getJSONObject(i);
                if (jtCode.equals(object.getString("jtCode"))) {
                    newDateArray.append(object.getString("usedate")).append(" 0 ");
                    continue;
                }
                newDateArray.append(object.getString("usedate")).append(" 1 ");
            }
            newDateArray.deleteCharAt(newDateArray.length() - 1);
            if (!oldDateArray.toString().equals(newDateArray.toString())) {
                result = false;
            }
            JSONObject details = SaiFuInfo.getStairPriceDetailsInfo().getJSONObject(jtCode);
            JSONObject details2 = !jtCode.equals(jtCode2) ? SaiFuInfo.getStairPriceDetailsInfo().getJSONObject(jtCode2) : details;
            if (result) {
                if (details2 == details) {
                    if (CommonTools.mul((Object)params.getString("RLPriceO1"), (Object)1000) != CommonTools.mul((Object)details.getString("jt_new_price_one"), (Object)1000) || CommonTools.mul((Object)params.getString("RLPriceO2"), (Object)1000) != CommonTools.mul((Object)details.getString("jt_new_price_two"), (Object)1000) || CommonTools.mul((Object)params.getString("RLPriceO3"), (Object)1000) != CommonTools.mul((Object)details.getString("jt_new_price_three"), (Object)1000) || CommonTools.mul((Object)params.getString("RLUGasO1"), (Object)1000) != CommonTools.mul((Object)details.getString("jt_new_gas_one"), (Object)1000) || CommonTools.mul((Object)params.getString("RLUGasO2"), (Object)1000) != CommonTools.mul((Object)details.getString("jt_new_gas_two"), (Object)1000)) {
                        result = false;
                    }
                } else if (CommonTools.mul((Object)params.getString("RLPriceO1"), (Object)1000) != CommonTools.mul((Object)details.getString("jt_new_price_one"), (Object)1000) || CommonTools.mul((Object)params.getString("RLPriceO2"), (Object)1000) != CommonTools.mul((Object)details.getString("jt_new_price_two"), (Object)1000) || CommonTools.mul((Object)params.getString("RLPriceO3"), (Object)1000) != CommonTools.mul((Object)details.getString("jt_new_price_three"), (Object)1000) || CommonTools.mul((Object)params.getString("RLUGasO1"), (Object)1000) != CommonTools.mul((Object)details.getString("jt_new_gas_one"), (Object)1000) || CommonTools.mul((Object)params.getString("RLUGasO2"), (Object)1000) != CommonTools.mul((Object)details.getString("jt_new_gas_two"), (Object)1000) || CommonTools.mul((Object)params.getString("RLPriceT1"), (Object)1000) != CommonTools.mul((Object)details2.getString("jt_new_price_one"), (Object)1000) || CommonTools.mul((Object)params.getString("RLPriceT2"), (Object)1000) != CommonTools.mul((Object)details2.getString("jt_new_price_two"), (Object)1000) || CommonTools.mul((Object)params.getString("RLPriceT3"), (Object)1000) != CommonTools.mul((Object)details2.getString("jt_new_price_three"), (Object)1000) || CommonTools.mul((Object)params.getString("RLUGasT1"), (Object)1000) != CommonTools.mul((Object)details2.getString("jt_new_gas_one"), (Object)1000) || CommonTools.mul((Object)params.getString("RLUGasT2"), (Object)1000) != CommonTools.mul((Object)details2.getString("jt_new_gas_two"), (Object)1000)) {
                    result = false;
                }
            }
            resultObject.put("result", result);
            resultObject.put("dateArray", (Object)newDateArray.toString());
            resultObject.put("typeNum", priceInfo.length());
            resultObject.put("planOne", (Object)details);
            resultObject.put("planTwo", (Object)details2);
        } else {
            resultObject = this.getStairData(useDateCode);
        }
        return resultObject;
    }

    public JSONObject getMaxData(String price) {
        JSONObject plan = new JSONObject().put("jt_new_price_one", (Object)price).put("jt_new_price_two", (Object)price).put("jt_new_price_three", (Object)price).put("jt_new_gas_one", (Object)"999999").put("jt_new_gas_two", (Object)"999999");
        JSONObject resultObject = new JSONObject();
        resultObject.put("result", false);
        resultObject.put("dateArray", (Object)"1 1 0");
        resultObject.put("typeNum", (Object)"1");
        resultObject.put("planOne", (Object)plan);
        resultObject.put("planTwo", (Object)plan);
        return resultObject;
    }

    public JSONObject getStairData(String useDateCode) {
        StringBuilder newDateArray = new StringBuilder();
        JSONArray priceInfo = SaiFuInfo.getStairPriceInfo().getJSONArray(useDateCode);
        JSONObject index = this.getJtCodeOrIndex(priceInfo);
        String jtCode = String.valueOf(index.getInt("index"));
        String jtCode2 = String.valueOf(index.getInt("index2"));
        for (int i = 0; i < priceInfo.length(); ++i) {
            JSONObject object = priceInfo.getJSONObject(i);
            if (jtCode.equals(object.getString("jt_code"))) {
                newDateArray.append(object.getString("usedate")).append(" 0 ");
                continue;
            }
            newDateArray.append(object.getString("usedate")).append(" 1 ");
        }
        newDateArray.deleteCharAt(newDateArray.length() - 1);
        JSONObject details = SaiFuInfo.getStairPriceDetailsInfo().getJSONObject(jtCode);
        JSONObject details2 = !jtCode.equals(jtCode2) ? SaiFuInfo.getStairPriceDetailsInfo().getJSONObject(jtCode2) : details;
        JSONObject resultObject = new JSONObject();
        resultObject.put("result", false);
        resultObject.put("dateArray", (Object)newDateArray.toString());
        resultObject.put("typeNum", priceInfo.length());
        resultObject.put("planOne", (Object)details);
        resultObject.put("planTwo", (Object)details2);
        return resultObject;
    }

    private JSONObject getPriceDetailsInfo(JSONArray jtInfo) throws Exception {
        if (jtInfo == null) {
            jtInfo = this.sqlServer.query("webmeterGetBaseData", new JSONObject().put("tableName", (Object)"t_ic_jt_type").put("items", (Object)"*").put("condition", (Object)"1=1"), Integer.valueOf(0));
        }
        JSONObject jtInfoData = new JSONObject();
        for (int i = 0; i < jtInfo.length(); ++i) {
            JSONObject object = jtInfo.getJSONObject(i);
            jtInfoData.put(object.getString("jt_code"), (Object)object);
        }
        return jtInfoData;
    }

    private JSONObject getPriceDateInfo(JSONArray jtDateInfo) throws Exception {
        if (jtDateInfo == null) {
            jtDateInfo = this.sqlServer.query("webmeter_singleTable_OrderBy", new JSONObject().put("tablename", (Object)"t_ic_jt_uesdate").put("items", (Object)"*").put("condition", (Object)"1=1").put("orderitem", (Object)"usedate"), Integer.valueOf(0));
        }
        JSONObject jtDateData = new JSONObject();
        for (int i = 0; i < jtDateInfo.length(); ++i) {
            JSONObject item = jtDateInfo.getJSONObject(i);
            String useDateCode = item.getString("usedate_code");
            String date = item.getString("usedate");
            int charP = date.indexOf("-");
            date = Integer.parseInt(date.substring(0, charP)) + " " + Integer.parseInt(date.substring(charP + 1));
            item.put("usedate", (Object)date);
            if (jtDateData.has(useDateCode)) {
                jtDateData.getJSONArray(useDateCode).put((Object)item);
                continue;
            }
            jtDateData.put(useDateCode, (Object)new JSONArray().put((Object)item));
        }
        return jtDateData;
    }

    public JSONObject getJtCodeOrIndex(JSONArray array) {
        JSONObject result = new JSONObject();
        int jtCode = array.getJSONObject(0).getInt("jt_code");
        result.put("index", jtCode);
        if (array.length() > 1) {
            for (int i = 1; i < array.length(); ++i) {
                int jtCode2 = array.getJSONObject(1).getInt("jt_code");
                if (jtCode2 >= jtCode) continue;
                result.put("index", jtCode2);
                result.put("index2", jtCode);
                break;
            }
        }
        if (!result.has("index2")) {
            result.put("index2", jtCode);
        }
        return result;
    }

    public boolean checkData() {
        return SaiFuInfo.checkData();
    }
}

