/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.TianXinTCPSystem;

import com.af.plugins.ConvertTools;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.DecoderException;
import org.json.JSONObject;

public class TianXinTCPSystem {
    public JSONObject enCodeData(byte[] resultData) throws DecoderException {
        JSONObject jsonObject = new JSONObject();
        if (resultData[0] == 62) {
            byte type = resultData[2];
            jsonObject.put("type", (int)type);
            JSONObject json = new JSONObject();
            if (type == 17) {
                json.put("returnCode", (Object)"success");
                json.put("meternumber", (Object)TianXinTCPSystem.byteToHexString(resultData, 3, 8));
                json.put("meterbrand", TianXinTCPSystem.getGas(resultData, 31, 8));
            } else if (type == 20) {
                json.put("returnCode", (Object)"success");
            } else if (type == 21) {
                json.put("returnCode", (Object)"success");
            } else if (type == 65) {
                json.put("returnCode", (Object)"success");
            } else if (type == 4) {
                json.put("returnCode", (Object)"success");
            } else if (type == -124) {
                jsonObject.put("type", 4);
                json.put("returnCode", (Object)"fail");
            }
            jsonObject.put("data", (Object)json);
        } else if (resultData[0] == 64) {
            jsonObject.put("type", 0);
            JSONObject json = new JSONObject();
            int i = 0;
            while (resultData[i] != 73) {
                ++i;
            }
            String result = new String(resultData, 2, i, StandardCharsets.UTF_8);
            json.put("returnCode", (Object)"success");
            json.put("meternumber", (Object)result);
            jsonObject.put("data", (Object)json);
        }
        return jsonObject;
    }

    private byte[] getInstruct(byte[] instruct) throws DecoderException {
        int length = instruct[1] & 0xFF;
        byte[] result = new byte[length];
        result[0] = 60;
        result[1] = (byte)length;
        System.arraycopy(instruct, 0, result, 0, length);
        byte[] crc16Byte = TianXinTCPSystem.HexToByte(TianXinTCPSystem.getCRC(result, length - 2));
        result[length - 2] = crc16Byte[1];
        result[length - 1] = crc16Byte[0];
        return result;
    }

    public byte[] changeMeterIP(String IP, int port) throws DecoderException {
        String[] ips = IP.split("\\.");
        byte[] data = new byte[11];
        data[0] = 60;
        data[1] = 12;
        data[2] = 4;
        data[3] = (byte)Integer.parseInt(ips[0]);
        data[4] = (byte)Integer.parseInt(ips[1]);
        data[5] = (byte)Integer.parseInt(ips[2]);
        data[6] = (byte)Integer.parseInt(ips[3]);
        byte[] HexPort = TianXinTCPSystem.HexToByte(Integer.toHexString(port));
        data[7] = HexPort[1];
        data[8] = HexPort[0];
        return this.getInstruct(data);
    }

    public byte[] ValveControl(int type) throws DecoderException {
        byte[] data = new byte[5];
        data[0] = 60;
        data[1] = 5;
        data[2] = type == 0 ? 20 : 21;
        return this.getInstruct(data);
    }

    public byte[] meterRead() throws DecoderException {
        byte[] data = new byte[5];
        data[0] = 60;
        data[1] = 5;
        data[2] = 17;
        return this.getInstruct(data);
    }

    public byte[] downloadMeterData(int gas) throws DecoderException {
        byte[] data = new byte[17];
        data[0] = 60;
        data[1] = 5;
        data[2] = 65;
        byte[] gasByte = TianXinTCPSystem.HexToByte(Integer.toHexString(gas));
        System.arraycopy(gasByte, 0, data, 10 - gasByte.length, gasByte.length);
        return this.getInstruct(data);
    }

    public byte[] endComm() throws DecoderException {
        byte[] data = new byte[5];
        data[0] = 60;
        data[1] = 5;
        data[2] = 18;
        return this.getInstruct(data);
    }

    private static String getCRC(byte[] bytes, int length) {
        int CRC = 65535;
        int POLYNOMIAL = 40961;
        for (int i = 0; i < length; ++i) {
            CRC ^= bytes[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((CRC & 1) != 0) {
                    CRC >>= 1;
                    CRC ^= POLYNOMIAL;
                    continue;
                }
                CRC >>= 1;
            }
        }
        return Integer.toHexString(CRC);
    }

    private static byte[] HexToByte(String hex) throws DecoderException {
        if ((hex.length() & 1) != 0) {
            hex = "0" + hex;
        }
        return ConvertTools.hexStrToByte((String)hex);
    }

    private static String byteToHexString(byte[] result, int offset, int length) throws DecoderException {
        byte[] hexbyte = new byte[length];
        System.arraycopy(result, offset, hexbyte, 0, length);
        return ConvertTools.byteToHexStr((byte[])hexbyte);
    }

    private static double getGas(byte[] result, int offset, int length) throws DecoderException {
        String hexStr = TianXinTCPSystem.byteToHexString(result, offset, length);
        long doubleBits = Long.parseLong(hexStr, 16);
        return Double.longBitsToDouble(doubleBits);
    }
}

