package com.aote.webmeter.module.weisidatcp;

import encryption.ceshi;
import entity.Command;
import org.json.JSONObject;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;


public class DecodeTool {

    private ceshi ce = new ceshi();

    /**
     * 创建开户指令代码
     * @param isOpenAccount 1 允许开户，0不允许开户
     * @return
     */
    public String createOpenAccount(String meterId,String isOpenAccount) throws Exception{
        Command command = new Command();
        command.setType("Fa");
        command.setId(meterId);
        if("1".equals(isOpenAccount) ){
            command.setSignA("00");
        } else {
            command.setSignA("11");
        }
        Command ret = ce.GetAllValues(command);
        return ret.getSendOut();
    }

    /**
     * 创建校时指令
     * @param DTUid
     * @return
     * @throws Exception
     */
    public String createTiming(String dtuId) throws Exception{
        Command command = new Command();
        command.setDTU(dtuId);
        command = ce.GetZhuCe(command);
        return command.getXiaoshi();
    }

    public static void main(String[] args) throws Exception{


        DecodeTool tool = new DecodeTool();
        System.out.println(tool.createHandPlan("12345678"));
////        String code1 = tool.createOpenAccount("12345678", "1");
////        String code2 = tool.createOpenAccount("12345678", "0");
////        System.out.println(code1);
////        System.out.println(code2);
////        System.out.println(tool.resolve("AA 67 FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF 55"));
////        System.out.println(tool.resolve("AA 14 12 34 56 78 D9 3B 3C 05 BC F3 40 64 EE CB 44 3A 24 55"));
//        //解析注册指令
//        System.out.println(tool.resolve("AA 14 12 34 56 78 EC 02 00 00 00 00 00 00 00 00 00 00 16 55 "));
//        System.out.println(tool.resolve("151515"));
//        /*解析充值返回指令*/
//        System.out.println(tool.resolve("AA 14 12 34 56 78 D9 3B 3C 05 BC F3 40 64 EE CB 44 3A 24 55"));
    }
    /**
     * 创建阀控指令
     * @param meterNumber 表具ID
     * @param isOpen 开阀1 关阀0
     * @return
     * @throws Exception
     */
    public String createValveController(String meterNumber,String isOpen) throws Exception{

        Command command = new Command();
        command.setId(meterNumber);

        if ("1".equals(isOpen)) {
            command.setType("F0");
        }else {
            command.setType("F1");
        }
        command = ce.GetAllValues(command);
        return command.getContext();
    }

    /**
     * 创建充值指令代码
     * @param meterNumber 设备号
     * @param value 气量
     * @return
     * @throws Exception
     */
    public String createRecharge(String meterNumber,String value) throws Exception{
        Command command = new Command();
        command.setType("F3");
        command.setId(meterNumber);
        command.setChongzhiMoney(value);
        command = ce.GetAllValues(command);
        return command.getContext();
    }

    /**
     * 创建冲正指令代码
     * @param meterNumber 表号
     * @param value 冲正的气量
     * @return
     */
    public String createCancelRecharge(String meterNumber,String value) throws Exception{
        ceshi ce = new ceshi();
        Command command = new Command();
        command.setType("F6");
        command.setId(meterNumber);

        if (Double.parseDouble(value) < 0) {
            value = (Double.parseDouble(value) * -1) + "";
        }
        System.out.println(value);


        command.setJianzhiMoney(value);
        command = ce.GetAllValues(command);
        return command.getContext();
    }

    /**
     * 创建抄表
     * @param meterNumber
     * @return
     */
    public String createHandPlan(String meterNumber) throws Exception{
        Command command = new Command();
        command.setType("F5");
        command.setId(meterNumber);
        command = ce.GetAllValues(command);
        return command.getContext();
    }

    /**
     * 创建读状态
     * @param meterNumber
     * @return
     * @throws Exception
     */
    public String createReadMeter(String meterNumber) throws Exception{
        Command command = new Command();

        command.setType("F5");
        ce.turn(command);
        command.setId(meterNumber);

        command = ce.GetAllValues(command);
        return command.getResponse();
    }

    /**
     * 解析
     * @param context 上报数据内容
     * @return
     * @throws Exception
     */
    public JSONObject resolve(String context) throws Exception{

        Command command = new Command();
        command.setContext(context);
        Command ret = ce.collection(command);
        if (ret == null) {
            return new JSONObject();
        }
        return new JSONObject(ret);

    }




    public String sendMessage(SocketChannel channel, String message) throws IOException {


        ByteBuffer outBuffer;
        message = message.replace(" ", "");
        outBuffer = ByteBuffer.wrap(hexTobytes(message));
        channel.write(outBuffer);
        return "已发送";
    }

    public static byte[] hexTobytes(String hex) {
        if (hex.length() < 1) {
            return null;
        } else {
            byte[] result = new byte[hex.length() / 2];
            int j = 0;
            for(int i = 0; i < hex.length(); i+=2) {
                result[j++] = (byte)Integer.parseInt(hex.substring(i,i+2), 16);
            }
            return result;
        }
    }
}
