package com.aote.webmeter.module.saifunb;

import com.aote.logic.LogicServer;
import org.json.JSONArray;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

/**
 * 处理表参数
 */
public class MeterParams {

    public static void main(String[] args) {
        String jsonStr = "{\"setFlowParams\": {\"flowmeterCode\":\"12\",\"flowmeterAddress\":\"西安市\",\"flowmeterCommMode\":\"通讯方式\"},\"setPeakStaggerParams\": {\"staggeringPeakDelay\":\"12\"},\"setUploadTime\": {\"uploadCycleType\":\"3\"}}";
        String ufJsonArr = "[{\"\"}]";
        MeterParams meterParams = new MeterParams();

    }
    /**
     * 前台传递两个串，一个userfilesjson数组，一个参数值数组
     * @param userJsonArr 用户信息json数组
     * @param paramsJsonArr  参数json数组
     * @param flag  区分保存和保存并发送  保存为save  保存并发送commit
     * @param sender  发送人
     * @param operator  操作人
     * @return
     */
    public JSONObject batchSaveParams(LogicServer logicServer, JSONArray userJsonArr, JSONArray paramsJsonArr, String flag, String sender, String operator) {
        // 统计成功和失败情况
        JSONObject jsonObject = new JSONObject();
        int success = 0;
        int fail = 0;
        // 判空处理
        if((userJsonArr == null && userJsonArr.length() < 1) ||
                (paramsJsonArr == null && paramsJsonArr.length() < 1)) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        //更新
        for(int i = 0; i < userJsonArr.length(); i++) {
            JSONObject data = new JSONObject();
            JSONObject userJson = userJsonArr.getJSONObject(i);
            String f_meternumber = userJson.getString("f_meternumber");
            JSONArray paramVArr = null;
            JSONObject paramValueList = null;
            // 需要存储到表信息中的那个json字段中
            JSONArray jsonArray1 = new JSONArray();
            if(!"null".equals(userJson.get("f_param_list").toString())) {
                paramVArr = new JSONArray(userJson.get("f_param_list").toString());
                jsonArray1 = paramVArr;
                for(int j = 0; j < paramVArr.length(); j++) {
                    // 如果是新的一个大类，就得直接添加，否则修改数据库里面的json串
                    JSONObject paramVJson = paramVArr.getJSONObject(j);
                    if(paramsJsonArr.getJSONObject(0).getString("name").equals(paramVJson.getString("name"))) {
                        paramValueList = transportJSONArr(paramsJsonArr, paramVJson);
                        //替换掉paramVArr存在的那个串
                        jsonArray1.remove(j);
                        break;
                    } else if(j == paramVArr.length() -1){
                        paramValueList = paramsJsonArr.getJSONObject(0);
                    }
                }
                jsonArray1.put(paramValueList);
            } else {
                // userfiles中的json串为空
                String valueStr = paramsJsonArr.toString().substring(1,paramsJsonArr.toString().length() -1);
                paramValueList = new JSONObject(valueStr);
                jsonArray1.put(paramValueList);
            }
            try {
                //进行指令保存
                getContentData(logicServer, paramsJsonArr, userJson,paramValueList, flag, sender, operator,jsonArray1);
            }catch(Exception ex) {
                System.out.println("指令保存失败");
                return null;
            }
            ////
            JSONObject recordJson = new JSONObject();
            //对表的参数json串单独处理

            recordJson.put("paramValueList", jsonArray1);
            recordJson.put("f_meternumber", f_meternumber);
            data.put("recordJson", recordJson);
            try {
                jsonArray.put(data);
                // 更新userfiles字段
                if(!"save".equals(flag)) {
                    logicServer.run("updateMeterInfo", data);
                }
                success++;
            } catch(Exception ex) {
                System.out.println("logic出错了");
                fail++;
                ex.printStackTrace();
            }
        }
        jsonObject.put("success", success);
        jsonObject.put("fail", fail);
        return jsonObject;
    }
    //保存一张表的所有参数指令和操作记录
    public JSONArray getContentData(LogicServer logicServer, JSONArray paramsJsonArr,JSONObject userJson,JSONObject paramValueList, String flag, String sender, String operator, JSONArray jsonArray1) throws Exception {
        JSONArray jsonArray = new JSONArray();
        String cardId = userJson.getString("f_barcode");
        String meterBrandName = userJson.getString("f_alias");
        String instructType = "设置参数";
        byte[] bytes = instructType.getBytes("gbk");
        instructType = new String(bytes,"gbk");
        JSONObject paramJSON = new JSONObject();
        //发送保存指令
        //指令内容
        JSONObject contentData = new JSONObject();
        //指令大类
        String setType = "";
        JSONObject jsonObject1 = paramsJsonArr.getJSONObject(0);
        Iterator<String> keys = jsonObject1.keys();
        //参数
        JSONObject paramMap = null;
        while(keys.hasNext()) {
            String title = keys.next();
            if (!"name".equals(title)) {
                paramMap = paramValueList.getJSONObject(title);
            } else {
                setType = jsonObject1.getString(title);
                byte[] bytess = setType.getBytes("gbk");
                setType = new String(bytess,"gbk");
            }
        }
        contentData.put("setType", setType);
        contentData.put("paramMap", paramMap);
        paramJSON.put("instructType", instructType);
        paramJSON.put("cardId", cardId);
        paramJSON.put("instructTitle", setType);
        paramJSON.put("meterBrandName", meterBrandName);
        paramJSON.put("contentData", contentData);
        System.out.println("指令参数串："+paramJSON.toString());
        //保存操作记录
        saveParamRecord(logicServer, paramJSON, userJson, paramValueList, flag, sender, operator, jsonArray1);
        if(!"save".equals(flag)) {
            logicServer.run("QinHuaSaveInstruct", paramJSON);
        }
        return jsonArray;
    }
    /*//保存一张表的所有参数指令和操作记录
    public JSONArray getContentData(LogicServer logicServer, JSONArray paramsJsonArr,JSONObject userJson,JSONObject paramValueList, String flag, String sender, String operator) throws Exception {
        JSONArray jsonArray = new JSONArray();
        String cardId = userJson.getString("f_barcode");
        String meterBrandName = userJson.getString("f_alias");
        String instructType = "设置参数";
        byte[] bytes = instructType.getBytes("gbk");
        instructType = new String(bytes,"gbk");
        for(int j = 0; j < paramsJsonArr.length(); j++) {
            JSONObject jsonObject1 = paramsJsonArr.getJSONObject(j);
            Iterator<String> keys = jsonObject1.keys();
            JSONObject paramMap = null; //参数
            String setType = ""; //指令大类
            while(keys.hasNext()) {
                String title = keys.next();
                if (!"name".equals(title)) {
                    paramMap = jsonObject1.getJSONObject(title);
                } else {
                    setType = jsonObject1.getString(title);
                    byte[] bytess = setType.getBytes("gbk");
                    setType = new String(bytess,"gbk");
                }
            }
            JSONObject paramJSON = new JSONObject();
            //发送保存指令
            JSONObject contentData = new JSONObject(); //指令内容
            contentData.put("setType", setType);
            contentData.put("paramMap", paramMap);
            paramJSON.put("instructType", instructType);
            paramJSON.put("cardId", cardId);
            paramJSON.put("instructTitle", setType);
            paramJSON.put("meterBrandName", meterBrandName);
            paramJSON.put("contentData", contentData);
            System.out.println("指令参数串："+paramJSON.toString());
            jsonArray.put(paramJSON);
            //保存操作记录
            saveParamRecord(logicServer, paramJSON, userJson, paramValueList, flag, sender, operator);
            if(!"save".equals(flag)) {
                logicServer.run("QinHuaSaveInstruct", paramJSON);
            }
        }
        return jsonArray;
    }*/

    /**
     * 添加操作记录
     */
    public void  saveParamRecord(LogicServer logicServer, JSONObject jsonObject, JSONObject userJson, JSONObject paramValueList, String flag, String sender, String operator, JSONArray jsonArray1) throws Exception {
        JSONArray jsonArray = new JSONArray();
        JSONObject data = new JSONObject();
        String f_barcode = userJson.getString("f_barcode");
        String f_meternumber = userJson.getString("f_meternumber");
        JSONObject recordJson = new JSONObject();
        recordJson.put("f_meternumber", f_meternumber);
        recordJson.put("f_metertype",userJson.getString("f_meter_type"));
        recordJson.put("paramValueList",paramValueList);
        recordJson.put("paramName", jsonObject.getJSONObject("contentData").getString("setType")); // 设置大类
        recordJson.put("f_outlets", "");
        recordJson.put("f_filiale", "");
        recordJson.put("setcontentData", jsonObject.getJSONObject("contentData"));
        recordJson.put("f_barcode",f_barcode);
        String isSend = "";
        if("save".equals(flag)) {
            isSend = "未发送";
        } else {
            isSend = "已发送";
            recordJson.put("sendTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        }
        recordJson.put("isSend", isSend);
        recordJson.put("sender", sender);
        recordJson.put("operator", operator);
        recordJson.put("operateTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        recordJson.put("result", "成功");
        recordJson.put("failReason", "");
        recordJson.put("content", "");
        recordJson.put("flag", flag);
        recordJson.put("paramArray", jsonArray1);
        data.put("recordJson", recordJson);
        logicServer.run("saveParamRecord", data);
    }



    /**
     * 修改数据库里面的json串
     * @param paramsJsonArr
     * @param paramVJson
     * @return
     */
    public JSONObject transportJSONArr(JSONArray paramsJsonArr, JSONObject paramVJson) {
        for(int i = 0; i < paramsJsonArr.length(); i++) {
            JSONObject jsonObject = paramsJsonArr.getJSONObject(i);
            Iterator<String> keys = jsonObject.keys();
            while(keys.hasNext()) {
                // 获得大类名称
                String title = keys.next();
                // name
                if (!"name".equals(title)) {
                    if(paramVJson.has(title)) {
                        // 两个大类一样时，的处理其中小类
                        // 数据库里面的json串
                        JSONObject jsonObject2 = paramVJson.getJSONObject(title);
                        // 这是页面修改的参数串
                        JSONObject jsonObject3 = jsonObject.getJSONObject(title);
                        Iterator<String> keys3 = jsonObject3.keys();
                        while(keys3.hasNext()) {
                            // 小类名称一样时处理
                            String next3 = keys3.next();
                            Object value3 = jsonObject3.get(next3);
                            if(jsonObject2.has(next3)) {
                                if("".equals(value3)) {
                                    // 对于前台参数值为空时，使用默认值
                                    value3 = jsonObject2.get(next3);
                                }
                                // 将修改的值替换掉数据库里面的json串中对应的参数值
                                jsonObject2.put(next3, value3);
                            } else {
                                //不一样进行追加
                                jsonObject2.put(next3, value3);
                            }
                        }
                    } else {
                        continue;
                    }
                } else {
                    continue;
                }
            }
        }
        return paramVJson;
    }


}
