package com.aote.webmeter.module.haiLiNewSystem;

import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

public class Tools {
    public static Long genTimeSpan() {
        return System.currentTimeMillis() / 1000;
    }

    private static JSONObject authorization = null;

    public static String genSid(int length) {
        String res = "";
        for (int i = 0; i < length; i++) {
            Random random = new Random();
            int nextInt = random.nextInt(10);
            res = res + nextInt;
        }
        return res;
    }

    public static JSONObject getAuthorization() {
        if (authorization == null) {
            return null;
        }
        //检查是否有效
        Long end_time = authorization.getLong("end_time");
        Long now_time = System.currentTimeMillis();
        if (now_time <= end_time) {
            return authorization;
        }
        authorization = null;
        return authorization;
    }

    public static void setAuthorization(JSONObject temp) {
        authorization = temp;
        Date endTime = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endTime);
        calendar.add(Calendar.SECOND, temp.getJSONObject("Result").getInt("ExpiresIn") - (30 * 60));
        endTime = calendar.getTime();
        authorization.put("end_time", endTime.getTime());
    }

    public static String getPriceStartDate() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        calendar.setTime(new Date());
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.DATE, 1);
        calendar.set(Calendar.MONTH, Calendar.JANUARY);
        return format.format(calendar.getTime());
    }
    public static String getPriceEndDate() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        calendar.setTime(new Date());
        calendar.set(Calendar.YEAR,calendar.get(Calendar.YEAR) + 30);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.DATE, 1);
        calendar.set(Calendar.MONTH, Calendar.JANUARY);
        return format.format(calendar.getTime());
    }

    public static void main(String[] args) {
        System.out.println(getPriceStartDate());;
        System.out.println(getPriceEndDate());;
    }
}
