package com.aote.webmeter.module.cangnantcp;

import java.util.Arrays;

public class HexUtils {

    /**
     * 用于建立十六进制字符的输出的小写字符数组
     */
    private static final char[] DIGITS_LOWER = {'0', '1', '2', '3', '4', '5',
            '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /**
     * 用于建立十六进制字符的输出的大写字符数组
     */
    private static final char[] DIGITS_UPPER = {'0', '1', '2', '3', '4', '5',
            '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    /**
     * 将字节数组转换为十六进制字符数组
     *
     * @param data byte[]
     * @return 十六进制char[]
     */
    public static char[] encodeHex(byte[] data) {
        return encodeHex(data, true);
    }

    /**
     * 将字节数组转换为十六进制字符数组
     *
     * @param data        byte[]
     * @param toLowerCase <code>true</code> 传换成小写格式 ， <code>false</code> 传换成大写格式
     * @return 十六进制char[]
     */
    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    /**
     * 将字节数组转换为十六进制字符数组
     *
     * @param data     byte[]
     * @param toDigits 用于控制输出的char[]
     * @return 十六进制char[]
     */
    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        // two characters form the hex value.
        for (int i = 0, j = 0; i < l; i++) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0x0F & data[i]];
        }
        return out;
    }

    /**
     * 将字节数组转换为十六进制字符串
     *
     * @param data byte[]
     * @return 十六进制String
     */
    public static String encodeHexStr(byte[] data) {
        return encodeHexStr(data, false);
    }

    /**
     * 将字节数组转换为十六进制字符串
     *
     * @param data        byte[]
     * @param toLowerCase <code>true</code> 传换成小写格式 ， <code>false</code> 传换成大写格式
     * @return 十六进制String
     */
    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return encodeHexStr(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    /**
     * 将字节数组转换为十六进制字符串
     *
     * @param data     byte[]
     * @param toDigits 用于控制输出的char[]
     * @return 十六进制String
     */
    protected static String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(encodeHex(data, toDigits));
    }

    /**
     * 将十六进制字符数组转换为字节数组
     *
     * @param data 十六进制char[]
     * @return byte[]
     * @throws RuntimeException 如果源十六进制字符数组是一个奇怪的长度，将抛出运行时异常
     */
    public static byte[] decodeHex(char[] data) {

        int len = data.length;

        if ((len & 0x01) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }

        byte[] out = new byte[len >> 1];

        // two characters form the hex value.
        for (int i = 0, j = 0; j < len; i++) {
            int f = toDigit(data[j], j) << 4;
            j++;
            f = f | toDigit(data[j], j);
            j++;
            out[i] = (byte) (f & 0xFF);
        }

        return out;
    }

    /**
     * 将十六进制字符转换成一个整数
     *
     * @param ch    十六进制char
     * @param index 十六进制字符在字符数组中的位置
     * @return 一个整数
     * @throws RuntimeException 当ch不是一个合法的十六进制字符时，抛出运行时异常
     */
    protected static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch
                    + " at index " + index);
        }
        return digit;
    }

    //ascii转换为string
    public static String AToString(int i){
        return Character.toString((char)i);
    }

    //字符串转换为ascii
    public static String StringToA(String content){
        String result = "";
        int max = content.length();
        for (int i=0; i<max; i++){
            char c = content.charAt(i);
            int b = (int)c;
            result = result + b;
        }
        return result;
    }

    /**
     * ASCII码字符串转十进制数字字符串
     * @param str
     * @return
     */
    public static String asciiHexStr2Str(String str)
    {
        StringBuffer sb = new StringBuffer();
        int index = 0;
        if (str.length() % 2 == 0){
            for (int i = 0; i < str.length() / 2; i++){
                int decimal = Integer.parseInt(str.substring(index, index + 2));
                if ((decimal - 30) >= 0 && (decimal - 30) <= 9){
                    sb.append(decimal - 30);
                }
                index += 2;
            }
        }
        return sb.toString();
    }


    public static byte[] str2Bcd(String asc) {
        int len = asc.length();
        int mod = len % 2;
        if (mod != 0) {
            asc = "0" + asc;
            len = asc.length();
        }
        byte[] abt;
        if (len >= 2) {
            len = len / 2;
        }
        byte[] bbt = new byte[len];
        abt = asc.getBytes();
        int j, k;
        for (int p = 0; p < asc.length() / 2; p++) {
            if ((abt[2 * p] >= '0') && (abt[2 * p] <= '9')) {
                j = abt[2 * p] - '0';
            } else if ((abt[2 * p] >= 'a') && (abt[2 * p] <= 'z')) {
                j = abt[2 * p] - 'a' + 0x0a;
            } else {
                j = abt[2 * p] - 'A' + 0x0a;
            }
            if ((abt[2 * p + 1] >= '0') && (abt[2 * p + 1] <= '9')) {
                k = abt[2 * p + 1] - '0';
            } else if ((abt[2 * p + 1] >= 'a') && (abt[2 * p + 1] <= 'z')) {
                k = abt[2 * p + 1] - 'a' + 0x0a;
            } else {
                k = abt[2 * p + 1] - 'A' + 0x0a;
            }
            int a = (j << 4) + k;
            byte b = (byte) a;
            bbt[p] = b;
//            System.out.format("%02X\n", bbt[p]);
        }
        return bbt;
    }

    /**
     * 将16进制字符串转换为byte[]
     *
     * @param str
     * @return
     */
    public static byte[] toBytes(String str) {
        if (str == null || "".equals(str.trim())) {
            return new byte[0];
        }

        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < str.length() / 2; i++) {
            String subStr = str.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte) Integer.parseInt(subStr, 16);
        }

        return bytes;
    }

    /**
     * 将字符串转为指定编码的16进制
     *
     * @param str
     * @return
     */
    public static String encode(String str) throws Exception {
        String hexString = "0123456789ABCDEF";
        //根据编码获取字节数组
        byte[] bytes = str.getBytes("GBK");
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        //将字节数组中每个字节拆解成2位16进制整数
        for (int i = 0; i < bytes.length; i++) {
            sb.append(hexString.charAt((bytes[i] & 0xf0) >> 4));
            sb.append(hexString.charAt((bytes[i] & 0x0f) >> 0));
        }
        return sb.toString();
    }

    // 从byte数组的index处的连续8个字节获得一个long
    public static long getLong(byte[] arr, int index) {
        return 	(0xff00000000000000L 	& ((long)arr[index+0] << 56))  |
                (0x00ff000000000000L 	& ((long)arr[index+1] << 48))  |
                (0x0000ff0000000000L 	& ((long)arr[index+2] << 40))  |
                (0x000000ff00000000L 	& ((long)arr[index+3] << 32))  |
                (0x00000000ff000000L 	& ((long)arr[index+4] << 24))  |
                (0x0000000000ff0000L 	& ((long)arr[index+5] << 16))  |
                (0x000000000000ff00L 	& ((long)arr[index+6] << 8))   |
                (0x00000000000000ffL 	&  (long)arr[index+7]);
    }

    public static double bytes2Double(byte[] arr) {
        long value = 0;
        for (int i = 0; i < 8; i++) {
            value |= ((long) (arr[i] & 0xff)) << (8 * i);
        }
        return Double.longBitsToDouble(value);
    }


    /**
     * 解析4个字节中的数据，按照IEEE754的标准
     */
    public static float bytesToFloat(byte[] data) {
        // 浮点数的符号
        int s = 0;
        // 浮点数
        float f = 0;
        // 指数
        int e = 0;
        // 求s
        if ((data[3] & 0xff) >= 128) {
            s = -1;
        } else {
            s = 1;
        }
        // 指数位的最后一位
        int temp;
        if ((data[2] & 0xff) >= 128) {
            temp = 1;
        } else {
            temp = 0;
        }
        // 求e
        e = ((data[3] & 0xff) % 128) * 2 + temp;
        // f=((data[2]&0xff)-temp*128+128)/128+(data[1]&0xff)/(128*256)+(data[0]&0xff)/(128*256*256);
        float[] data2 = new float[3];
        data2[0] = data[0] & 0xff;
        data2[1] = data[1] & 0xff;
        data2[2] = data[2] & 0xff;
        f = (data2[2] - temp * 128 + 128) / 128 + data2[1] / (128 * 256)
                + data2[0] / (128 * 256 * 256);
        float result;
        // 次正规数
        if (e == 0 && f != 0) {
            result = (float) (s * (f - 1) * Math.pow(2, -126));
            return result;
        }
        // 有符号的0
        if (e == 0) {
            result = (float) 0.0;
            return result;
        }
        // 正无穷大
        if (s == 0 && e == 255 && f == 0) {
            result = (float) 1111.11;
            return result;
        }
        // 负无穷大
        if (s == 1 && e == 255 && f == 0) {
            result = (float) -1111.11;
        } else {
            result = (float) (s * f * Math.pow(2, e - 127));
        }
        return result;

    }

    /**
     * 将字节数组转换成2进制字符串
     * @param bytes
     * @return
     */
    public static String bytes2BinaryStr(byte[] bytes){
        StringBuffer binaryStr = new StringBuffer();
        for(int i=0;i<bytes.length;i++){
            String str = Integer.toBinaryString((bytes[i] & 0xFF) + 0x100).substring(1);
            binaryStr.append(str);
        }
        return binaryStr.toString();
    }

    public static float bytes2Float(byte[] bytes){
        //获取 字节数组转化成的2进制字符串
        String binaryStr = bytes2BinaryStr(bytes);
        //符号位S
        Long s = Long.parseLong(binaryStr.substring(0, 1));
        //指数位E
        Long e = Long.parseLong(binaryStr.substring(1, 9),2);
        //位数M
        String M = binaryStr.substring(9);
        float m = 0,a,b;
        for(int i=0;i<M.length();i++){
            a = Integer.parseInt(M.charAt(i)+"");
            b = (float) Math.pow(2, i+1);
            m =m + (a/b);
        }
        return (float) ((Math.pow(-1, s)) * (1+m) * (Math.pow(2,(e-127))));
    }

    public static void main(String[] args) {
        // 字节数组转为hex字符串
//        byte[] data = {23, 83, 25, 127, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 0, 0, 0, 0, 0, 23, 0, 127, 127, 127, 3, 0, 2, -12, -71};
//        byte[] dataWithoutCRC = {23, 83, 25, 127, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 0, 0, 0, 0, 0, 23, 0, 127, 127, 127, 3, 0, 2};
//        System.out.println(CRCUtils.getCRC2(dataWithoutCRC));
//        System.out.println(encodeHexStr(data));
//        System.out.println(Arrays.toString(toBytes(encodeHexStr(data))));
//
        String ascii = "31323334353637383930310000000000";
        System.out.println(asciiHexStr2Str(ascii));
//        //集中器表号，既设置卡的DTU编号，10字节bcd
//        System.out.println(Arrays.toString(str2Bcd("00000000012345678901")));
//        System.out.println("集中器表号:" + HexUtils.encodeHexStr(str2Bcd("00000000012345678901")));
//        //流量计编号，既卡号,6字节bcd
//        System.out.println(Arrays.toString(str2Bcd("001122334455")));
//        System.out.println("流量计编号:" + HexUtils.encodeHexStr(str2Bcd("001122334455")));
//
//        System.out.println(Arrays.toString(str2Bcd("12345678901")));
//        System.out.println(encodeHex(str2Bcd("015594948878"), true));

        System.out.println(Arrays.toString(str2Bcd("2D877BE0")));
        System.out.println(encodeHex(str2Bcd("2D877BE0"), true));
        //40658000
        System.out.println(Arrays.toString(str2Bcd("40658000")));
        System.out.println(encodeHex(str2Bcd("40658000"), true));
        String dFloat = "4065800000000000";
        String sFloat = "41A00000";
//        byte[] arr = toBytes(gasInMeter);
//        System.out.println(bytes2Double(arr));
//        System.out.println(Double.doubleToLongBits(172));
        System.out.println(Double.longBitsToDouble(Long.valueOf(dFloat, 16)));
        System.out.println(Float.intBitsToFloat(Integer.valueOf(sFloat, 16)));
        System.out.println(Integer.valueOf(sFloat, 16));

//        String srcStr = "5586276168882545";
//        String encodeStr = encodeHexStr(srcStr.getBytes(), true);
//        String decodeStr = new String(decodeHex(encodeStr.toCharArray()));
//        System.out.println("转换前：" + srcStr);
//        System.out.println("转换后：" + encodeStr);
//        System.out.println("还原后：" + decodeStr);
    }

}
