package com.aote.webmeter.module.TianXinTCPSystem;


import com.af.plugins.ConvertTools;
import org.apache.commons.codec.DecoderException;
import org.json.JSONObject;
import java.nio.charset.StandardCharsets;


public class TianXinTCPSystem {

    /**
     * 解析表具上传数据
     * @param resultData 表具上传数据
     * @return 返回对应的数据   {"type" : 0 , "data":{"returnCode":"success" , "meternumber" : "123456789012"}}
     * @throws DecoderException
     */
    public JSONObject enCodeData(byte[] resultData) throws DecoderException {
        JSONObject jsonObject = new JSONObject();

        if (resultData[0] == 0x3E) {
            int type = resultData[2];
            jsonObject.put("type", type);
            JSONObject json = new JSONObject();
            if (type == 0x11) {
                json.put("returnCode","success");
                json.put("meternumber",byteToHexString(resultData,3,8));
                json.put("meterbrand",getGas(resultData,31,8));
            } else if (type == 0x14) {
                json.put("returnCode","success");
            } else if (type == 0x15) {
                json.put("returnCode","success");
            } else if (type == 0x41) {
                json.put("returnCode","success");
            } else if (type == 0x04) {
                json.put("returnCode","success");
            } else if (type == (byte) 0x84) {
                jsonObject.put("type", 0x04);
                json.put("returnCode","fail");
            }
            jsonObject.put("data", json);

        } else if (resultData[0] == 0x40) {
            jsonObject.put("type", 0);
            JSONObject json = new JSONObject();

            int i = 0;

            while(resultData[i] != 0x49){
                i++;
            }
            String result = new String(resultData,2,i, StandardCharsets.UTF_8);
            json.put("returnCode","success");
            json.put("meternumber", result);

            jsonObject.put("data", json);

        }
        return jsonObject;
    }



    //组合各个指令的HEX字符串
    private byte[] getInstruct(byte[] instruct) throws DecoderException {

        int length = instruct[1] & 0xFF;
        byte[] result = new byte[length];
        result[0] = (byte) 0x3C;
        result[1] = (byte) length;

        System.arraycopy(instruct, 0, result, 0, length);

        byte[] crc16Byte = HexToByte(getCRC(result, length - 2));

        result[length - 2] = crc16Byte[1];
        result[length - 1] = crc16Byte[0];

        return result;

    }

    /**
     * 修改表具ip地址
     * @param IP  ip地址  127.0.0.1
     * @param port 端口号   8080
     * @return 需要发送的Hex字符串
     */

    public byte[] changeMeterIP(String IP, int port) throws DecoderException {

        String[] ips = IP.split("\\.");

        byte[] data = new byte[11];

        data[0] = (byte)0x3c;
        data[1] = (byte)0x0C;
        data[2] = (byte)0x04;

        data[3] = (byte)Integer.parseInt(ips[0]);
        data[4] = (byte)Integer.parseInt(ips[1]);
        data[5] = (byte)Integer.parseInt(ips[2]);
        data[6] = (byte)Integer.parseInt(ips[3]);

        byte[] HexPort = HexToByte(Integer.toHexString(port));

        data[7] = HexPort[1];
        data[8] = HexPort[0];

        return  getInstruct(data);

    }

    /**
     * 阀门控制
     * @param type  0：开阀   其他：关阀
     * @return  需要发送的byte数据
     * @throws DecoderException byte与Hex转换错误
     */
    public  byte[] ValveControl(int type) throws DecoderException {

        byte[] data = new byte[5];
        data[0] = 0x3C;
        data[1] = 0x05;
        if(type == 0){
            data[2] = 0x14;
        }else {
            data[2] = 0x15;
        }

        return getInstruct(data);

    }

    /**
     * 发送获取当前表具数据的指令
     * @return
     * @throws DecoderException
     */
    public  byte[] meterRead() throws DecoderException {
        byte[] data = new byte[5];
        data[0] = 0x3C;
        data[1] = 0x05;
        data[2] = 0x11;

        return getInstruct(data);

    }


    /**
     * 下发当前表的结算剩余量和价格
     * @return
     * @throws DecoderException
     */
    public  byte[] downloadMeterData(int gas) throws DecoderException {
        byte[] data = new byte[17];
        data[0] = 0x3C;
        data[1] = 0x05;
        data[2] = 0x41;

        byte[] gasByte = HexToByte(Integer.toHexString(gas));

        System.arraycopy(gasByte,0,data,10-gasByte.length,gasByte.length);

        return getInstruct(data);

    }


    /***
     * 结束通信
     * @return
     * @throws DecoderException
     */
    public byte[] endComm() throws DecoderException {
        byte[] data = new byte[5];
        data[0] = 0x3C;
        data[1] = 0x05;
        data[2] = 0x12;

        return getInstruct(data);

    }

    private static String getCRC(byte[] bytes,int length) {
        int CRC = 0x0000ffff;
        int POLYNOMIAL = 0x0000a001;

        int i, j;
        for (i = 0; i < length; i++) {
            CRC ^= ((int) bytes[i] & 0x000000ff);
            for (j = 0; j < 8; j++) {
                if ((CRC & 0x00000001) != 0) {
                    CRC >>= 1;
                    CRC ^= POLYNOMIAL;
                } else {
                    CRC >>= 1;
                }
            }
        }
        return Integer.toHexString(CRC);
    }


    private static byte[] HexToByte(String hex) throws DecoderException {


        if ((hex.length() & 0x01) != 0) {
            hex = "0" + hex;
        }
        return ConvertTools.hexStrToByte(hex);
    }

    private static String byteToHexString(byte[] result, int offset , int length) throws DecoderException {

        byte[] hexbyte = new byte[length];

        System.arraycopy(result,offset,hexbyte,0,length);

        return ConvertTools.byteToHexStr(hexbyte);

    }

    private static double getGas(byte[] result, int offset , int length) throws DecoderException{


        String hexStr = byteToHexString(result,offset,length);

        long doubleBits  = Long.parseLong(hexStr,16);

        return Double.longBitsToDouble(doubleBits);

    }

}
