package com.aote.webmeter.tools;

import com.af.plugins.JsonTools;
import com.af.plugins.iot.WebMeterInfo;
import org.json.JSONObject;

/**
 * 物联网表指令工具（V1.0）
 * 指令-逻辑映射配置：mainInstructs.json
 * @author Mrriver
 * @date 2019/3/29
 */

public class GetInstructsTools {
    /**
     * 指令-逻辑映射列表
     */
    private static JSONObject instructList;
    static {
        //加载指令-逻辑映射
        if (GetInstructsTools.class.getClassLoader().getResourceAsStream("webmeter/mainInstructs.json") != null){
            instructList = JsonTools.readJsonFile("webmeter/mainInstructs.json");
        } else {
            throw new RuntimeException("缺少指令-逻辑映射文件：mainInstructs.json");
        }
    }

    /**
     * 获取指令-业务逻辑名
     * @param instructName 指令中文名
     * @return 业务逻辑名
     */
    public String getInstruct(String instructName) {
        if (instructList.has(instructName)){
            String moduleName = WebMeterInfo.getModuleName();
            String logicName = instructList.getString(instructName);
            return moduleName+logicName;
        } else {
            throw new RuntimeException("未映射【"+instructName+"】的指令");
        }
    }
}
