SELECT * from(
	SELECT
		{groupname},
		SUM(f_type0) f_type0, 		    --总标记数
		SUM(f_type1) f_type1,			--待处理总数量
		SUM(f_type2) f_type2,			--已处理总数量
		SUM(f_type3) f_type3,			--types的待处理总数量
		SUM(f_type4) f_type4			--types的已处理总数量
	FROM(
		SELECT
			year,
			month,
			week,
			day,
			f_user_type,
			f_gasproperties,
			f_gasproperties2,
			f_filiale,
			version,
			category,
			f_type1+f_type2 f_type0,
			f_type1,
			f_type2,
			case when (f_type1=1 and {types}=1) then 1 else 0 end f_type3,
			case when (f_type2=1 and {types}=1) then 1 else 0 end f_type4
		FROM(
			SELECT
				f.f_user_type,
				f.f_gasproperties,
				f.f_gasproperties2,
				f.f_filiale,
				f.version,
				case WHEN p.f_parameter_name IN ('频繁磁干扰','频繁报拆表','连续失联','频繁报过流保护关阀','负值故障')
			 THEN '故障型' ELSE '警示型' END category,
				convert(varchar(4),p.f_parameter_date,23)+'年' year,
				convert(varchar(7),p.f_parameter_date,23) month,
				cast(Datename(week,p.f_parameter_date) as varchar)+'周'  week,
				convert(varchar(50),p.f_parameter_date,23) day,
				case when p.f_parameter_name='频繁磁干扰' then 1 else 0 end type1,
				case when p.f_parameter_name='频繁间断性失联' then 1 else 0 end type2,
				case when p.f_parameter_name='频繁指令下发失败' then 1 else 0 end type3,
				case when p.f_parameter_name='锂电低电' then 1 else 0 end type4,
				case when p.f_parameter_name='频繁拆表报警' then 1 else 0 end type5,
				case when p.f_parameter_name='未装电池' then 1 else 0 end type6,
				case when p.f_parameter_name='e7单干簧管故障' then 1 else 0 end type7,
				case when p.f_parameter_name='e8双干簧管故障' then 1 else 0 end type8,
				case when p.f_parameter_name='关阀过气' then 1 else 0 end type9,
				case when p.f_parameter_name='液晶显示不全' then 1 else 0 end type10,
				case when p.f_parameter_name='频繁报过流保护关阀' then 1 else 0 end type11,
				case when p.f_parameter_name='负值故障' then 1 else 0 end type12,
				case when p.f_parameter_name='其他' then 1 else 0 end type13,
				case when p.f_parameter_state='待处理' then 1 else 0 end f_type1,
				case when p.f_parameter_state='-处理-' then 1 else 0 end f_type2
			from t_userparameter p
			INNER JOIN t_userfiles AS f ON p.f_meternumber = f.f_meternumber
			INNER JOIN t_userinfo AS u ON f.f_userinfo_id = u.f_userinfo_id
			where f_parameter_state!='处理完成' and {condition}
		) s
	) s
	GROUP BY {groupname}
) s
ORDER BY {groupname}