select
  *
from (
select
 u.f_meternumber,   --表钢号
 uf.f_userinfo_code, --用户编号
 uf.f_user_name,	--用户姓名
 uf.f_address,		--用户地址
 u.f_gas_date,		--开户日期
 u.f_user_type,		--用户类型
 u.f_gasproperties, --用气类型
 u.f_gasproperties2, --用气属性
 case when s.max_days is null
 then  (case
	when DATEDIFF(day, u.f_gas_date,'{endDate}')<0 then 0
	when DATEDIFF(day, u.f_gas_date,'{startDate}')>=0 then DATEDIFF(day, '{startDate}','{endDate}')
	else DATEDIFF(day, u.f_gas_date,'{endDate}')
	end) else s.max_days end max_days,		--最长失联天数
 case when s.all_days is null
 then  (case
	when DATEDIFF(day, u.f_gas_date,'{endDate}')<0 then 0
	when DATEDIFF(day, u.f_gas_date,'{startDate}')>=0 then DATEDIFF(day, '{startDate}','{endDate}')
	else DATEDIFF(day, u.f_gas_date,'{endDate}')
	end) else s.all_days end all_days ,		--合计失联天数
 s.min_insert_date,	--期初上报日期
 s.max_insert_date,	--期末上报日期
 DATEDIFF(day, '{startDate}','{endDate}')-all_days-1 c,				--期间上报天数
 case when s1.new_days is null then DATEDIFF(day, u.f_gas_date,getdate())-1 else s1.new_days end new_days,		--最新失联天数
 case when s1.f_state is null then '从未上报' else s1.f_state end f_state, --期间未上报
 case
  when  max_days is null then '期间未上报'
  when  max_days =0 then '从未失联'
  when  max_days>0 and max_days<5 then '5天之内'
  when  max_days>=5 and max_days<7 then '5-7天'
  when  max_days>=7 and max_days<15 then '7-15天'
  when  max_days>=15 and max_days<30 then '15-30天'
  when  max_days>=30 and max_days<60  then '30-60天'
  else  '60天以上' end  max_days_type,  --最长失联天数类型
 case
  when  all_days is null then '期间未上报'
  when  all_days =0 then '从未失联'
  when  all_days>0 and all_days<5 then '5天之内'
  when  all_days>=5 and all_days<7 then '5-7天'
  when  all_days>=7 and all_days<15 then '7-15天'
  when  all_days>=15 and all_days<30 then '15-30天'
  when  all_days>=30 and all_days<60  then '30-60天'
  else  '60天以上' end  all_days_type,  --合计失联天数类型
  u.f_filialeids,
  u.f_filiale,
  f_parameter_name,
  CASE WHEN f_parameter_name ='未装电池' then '未装电池' ELSE '电池正常' end f_battery_status,
CASE WHEN f_parameter_state is null then '未标记' ELSE '已标记' end f_parameter_state,
  u.f_outlets
from
 t_userfiles u
 left join t_userinfo uf on u.f_userinfo_id=uf.f_userinfo_id
 left join
(
	--查询用户失联情况
	select
		s.f_user_id,	--表编号
		f_userinfo_id, --用户编号
		s.f_meternumber, --表号
		f_gas_date, --开户日期
		case when DATEDIFF(day, max(f_insert_date),'{endDate}')-1>max(CASE when days<=1 then 0 ELSE days-1 END) then
		 DATEDIFF(day, max(f_insert_date),'{endDate}')-1
		 else max(CASE when days<=1 then 0 ELSE days-1 END) end max_days,
		 --最长失联天数
		sum(CASE when days<=1 then 0 ELSE days-1 END)+
			case when DATEDIFF(day, max(f_insert_date),'{endDate}')-1>0
			then DATEDIFF(day, max(f_insert_date),'{endDate}')-1 else 0 end  all_days, --合计失联天数
		min(f_insert_date) min_insert_date, --首次上报日期
		max(f_insert_date) max_insert_date --最后上报日期
		--count(*) c --合计上报次数
	from(
		select
			 f_user_id,
			 f_userinfo_id,
			 f_meternumber,
			 convert(varchar(100),f_gas_date,20) f_gas_date,
			 f_hand_date f_insert_date,
			 f_last_hand_date f_last_insertdate,
			 case when f_last_hand_date is null then 0 else
			 (case when DATEDIFF(day, (case when f_last_hand_date>='{startDate}' then f_last_hand_date else '{startDate}' end), f_hand_date)<=1 then 0
			 else DATEDIFF(day, (case when f_last_hand_date>='{startDate}'then f_last_hand_date else '{startDate}' end), f_hand_date) end) end days
		from t_meteread
		where f_hand_date>='{startDate}' and f_hand_date<='{endDate}'
	) s
	group by s.f_user_id,f_userinfo_id,s.f_meternumber,f_gas_date
) s  on u.f_user_id=s.f_user_id and s.f_meternumber=u.f_meternumber
 left join (select f_user_id,f_meternumber,f_parameter_date,f_parameter_name,f_parameter_state
		from t_userparameter
	) p on u.f_user_id=p.f_user_id and p.f_meternumber=u.f_meternumber AND s.max_insert_date<p.f_parameter_date and p.f_parameter_date<='{endDate}'
left join (
	--查询该表具最后上报日期，从而判断该表具目前最新的状态
	select
		f_user_id,
		f_meternumber,
		case when DATEDIFF(day, max(f_hand_date), getdate())>1 then '失联' else '正常' end f_state,
		case when DATEDIFF(day, max(f_hand_date), getdate())>1 then DATEDIFF(day, max(f_hand_date), getdate())-1 else 0 end new_days,
		max(f_hand_date) max_insert_date
	from t_meteread
	group by f_user_id,f_meternumber
) s1 on s1.f_user_id=u.f_user_id and s1.f_meternumber=u.f_meternumber
where
u.f_gas_date<='{endDate}' and
u.f_table_state='正常' and uf.f_user_state='正常'
) s
where {condition}
order by f_gas_date