select
	f_lost_contact_days,    --最长失联天数
	cishu,                  --失联次数
	u.f_meternumber,        --表号
	f_imei,                 --imei码  国际移动设备身份码
	f_iot_type,             --表通道类型
	f_device_id,            --设备号
	f_filialeids,           --组织机构串
	f_filiale,              --组织机构
	f_userinfo_code,        --用户编号
	f_user_name,            --用户姓名
	f_address,              --地址
	f_gas_date,             --通气时间
	f_user_type,            --用户类型
	f_gasproperties,        --用气性质
	f_gasproperties2,       --用气属性
	f_meteread_date,        --最新上报时间
	newdays                 --最新失联天数
from (
select
		uf.f_filialeids,
		uf.f_filiale,
		uf.f_meternumber,
		u.f_userinfo_code,
		u.f_user_name,
		u.f_address,
		uf.f_gas_date,
		uf.f_user_type,
		uf.f_gasproperties,
		uf.f_gasproperties2,
		uf.f_meteread_date,
		case when uf.f_meteread_date is null then DATEDIFF(day, uf.f_gas_date,getdate())-1
		else DATEDIFF(day, uf.f_meteread_date,getdate())-1 end newdays
	from  t_userfiles uf
	left join t_userinfo u on uf.f_userinfo_id=u.f_userinfo_id
	where uf.f_table_state='正常' and u.f_user_state='正常'
) u
left join (
		select max(f_lost_contact_days) f_lost_contact_days,count(1) cishu,
	f_meternumber,f_imei,f_iot_type,f_device_id
	 from t_meterlostcontact
	 where f_lost_begin_date>='{startDate}' and f_lost_begin_date<='{endDate}'
	 group by f_meternumber,f_imei,f_iot_type,f_device_id
) m on u.f_meternumber=m.f_meternumber
where {condition}
order by newdays desc

