SELECT * from(
	SELECT
		s.f_meternumber,										--表钢号
		f_userinfo_code,										--用户编号
		f_user_name,											--用户姓名
		f_user_type,											--用户类型
		f_gasproperties,										--用气性质
		f_address,												--用户地址
		f_gasproperties2,										--用气属性
		f_filiale,												--组织机构
		f_table_state,
		minTime,	                                            --最早标记时间
		t,														--期间标记次数
		category,												--标记类别
		maxTime,			                                    --最晚标记时间
		s.f_parameter_name,							            --标记名称
		up.lastTime										        --上次标记时间
	FROM(
		SELECT
			p.f_meternumber,
			u.f_userinfo_code,
			u.f_user_name,
			u.f_address,
			f.f_filiale,
			f.f_user_type,
			f.f_gasproperties,
			f.f_gasproperties2,
			f.f_user_id,
			f.f_table_state,                 --表具状态
			max(p.f_parameter_date) maxTime,
			MIN(p.f_parameter_date) minTime,
			case WHEN f_parameter_name IN ('频繁磁干扰','频繁报拆表','连续失联','频繁报过流保护关阀','负值故障')
			 THEN '故障型' ELSE '警示型' END category,
			1 t,
			f_parameter_name
		from t_userparameter p
		LEFT JOIN t_userfiles AS f ON p.f_meternumber = f.f_meternumber
		LEFT JOIN t_userinfo AS u ON f.f_userinfo_id = u.f_userinfo_id
		where f_parameter_state!='处理完成' and {condition}
		GROUP BY p.f_meternumber,u.f_userinfo_code,u.f_user_name,f.f_user_type,
	f.f_gasproperties,u.f_address,f.f_gasproperties2,f.f_filiale,f_parameter_name,f.f_table_state,f.f_user_id
	) s
	LEFT JOIN (
		SELECT f_parameter_name,MAX(f_parameter_date) lastTime,f_user_id,f_meternumber from t_userparameter
		where f_parameter_state!='处理完成'
		GROUP BY f_parameter_name,f_meternumber,f_user_id
	) up ON s.f_meternumber=up.f_meternumber and up.f_parameter_name=s.f_parameter_name and up.f_user_id=s.f_user_id
) s
ORDER BY f_meternumber