SELECT
	*
FROM
	(
SELECT
	ISNULL( ui.f_address, 'NULL' ) f_address,
	ISNULL( ui.f_area, 'NULL' ) f_area,
	ISNULL( ui.f_slice_area, 'NULL' ) f_slice_area,
	ISNULL( ui.f_street, 'NULL' ) f_street,
	ISNULL( ui.f_residential_area, 'NULL' ) f_residential_area,
	mr.day,
	ui.f_user_name,
	uf.f_user_id,
	isnull( mr.f_tablebase, 0 ) f_tablebase,
	isnull( mr.f_last_tablebase, 0 ) f_last_tablebase,
	ISNULL( isnull( mr.f_tablebase, 0 ) - isnull( mr.f_last_tablebase, 0 ), 0 ) usergas
FROM
	t_userinfo ui,
	t_userfiles uf
	LEFT JOIN (
SELECT
	f_user_id,
	MAX ( f_tablebase ) f_tablebase,
	MIN ( f_last_tablebase ) f_last_tablebase,
	md.day
FROM
	t_meteread mr,
	(
SELECT CONVERT
	( VARCHAR ( 10 ), dateadd( DAY, t2.number, t1.day ), 120 ) DAY
FROM
	( SELECT '{month}' + '-01' DAY ) t1,
	( SELECT number FROM MASTER..spt_values WHERE TYPE = 'P' AND number >= 0 AND number <= 31 ) t2
WHERE
	CONVERT ( VARCHAR ( 10 ), dateadd( DAY, t2.number, t1.day ), 120 ) LIKE '{month}%'
	) md
WHERE
	f_hand_date BETWEEN CONVERT ( DATETIME, md.day + ' 00:00:00' )
	AND CONVERT ( DATETIME, md.day + ' 23:59:59' )
GROUP BY
	f_user_id,
	md.day
	) mr ON ( uf.f_user_id= mr.f_user_id )
WHERE
	uf.f_userinfo_id= ui.f_userinfo_id
	AND uf.f_meter_classify= '物联网表'
	AND {condition}
	) f
