package com.aote.webmeter.module.xinlisystem;

import org.json.JSONObject;

import java.util.Calendar;
import java.util.Date;

/**
 * 杭州新力系统兼容工具
 * @author Mrriver
 */
public class XinLiSystemTools {
    private static JSONObject getPriceChangeInfo(String month,String day){
        if(month.length() == 1) {
            month = "0"+month;
        }
        if(day.length() == 1) {
            day = "0"+day;
        }
        String thisTime = month+"-"+day;
        JSONObject result = new JSONObject();
        System.out.println(thisTime);
        result.put("months","2");
        if ((thisTime.compareTo("03-15") >= 0) && (thisTime.compareTo("05-15") < 0)){
            result.put("date","0515");
        } else if ((thisTime.compareTo("05-15") >= 0) && (thisTime.compareTo("07-15") < 0))
        {
            result.put("date","0715");
        } else if ((thisTime.compareTo("07-15") >= 0) && (thisTime.compareTo("09-15") < 0))
        {
            result.put("date","0915");
        } else if ((thisTime.compareTo("09-15") >= 0) && (thisTime.compareTo("11-15") < 0))
        {
            result.put("date","1115");
        } else {
            result.put("date","0315");
            result.put("months","4");
        }
        return result;
    }

    // 计算开始时间方法
    public static JSONObject countDate(Date date) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        String month = String.valueOf(now.get(Calendar.MONTH)+1);
        String day = String.valueOf(now.get(Calendar.DATE));
        return getPriceChangeInfo(month,day);
    }

    // 计算预调价
    public static JSONObject prepareCountDate() {
        Calendar now = Calendar.getInstance();
        String month = String.valueOf(now.get(Calendar.MONTH)+1);
        String day = "15";
        return getPriceChangeInfo(month,day);
    }
}
